/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.lazy.layout.LazyLayoutAnimateScrollScope;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerState;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a8\u0006\u0004"}, d2={"PagerLazyAnimateScrollScope", "Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimateScrollScope;", "state", "Landroidx/compose/foundation/pager/PagerState;", "foundation"})
public final class PagerLazyAnimateScrollScopeKt {
    @ExperimentalFoundationApi
    @NotNull
    public static final LazyLayoutAnimateScrollScope PagerLazyAnimateScrollScope(@NotNull PagerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new LazyLayoutAnimateScrollScope(state){
            final /* synthetic */ PagerState $state;
            {
                this.$state = $state;
            }

            public int getFirstVisibleItemIndex() {
                return this.$state.getFirstVisiblePage$foundation();
            }

            public int getFirstVisibleItemScrollOffset() {
                return this.$state.getFirstVisiblePageOffset$foundation();
            }

            public int getLastVisibleItemIndex() {
                return ((PageInfo)CollectionsKt.last(this.$state.getLayoutInfo().getVisiblePagesInfo())).getIndex();
            }

            public int getItemCount() {
                return this.$state.getPageCount();
            }

            public int getVisibleItemScrollOffset(int index2) {
                PageInfo pageInfo;
                block1: {
                    List<PageInfo> $this$fastFirstOrNull$iv = this.$state.getLayoutInfo().getVisiblePagesInfo();
                    boolean $i$f$fastFirstOrNull = false;
                    List<PageInfo> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv$iv.size();
                    for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        PageInfo item$iv$iv;
                        PageInfo it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        boolean bl = false;
                        PageInfo it = it$iv;
                        boolean bl2 = false;
                        if (!(it.getIndex() == index2)) continue;
                        pageInfo = it$iv;
                        break block1;
                    }
                    pageInfo = null;
                }
                PageInfo pageInfo2 = pageInfo;
                return pageInfo2 != null ? pageInfo2.getOffset() : 0;
            }

            public void snapToItem(@NotNull ScrollScope $this$snapToItem, int index2, int scrollOffset) {
                Intrinsics.checkNotNullParameter((Object)$this$snapToItem, (String)"<this>");
                float finalOffset = (float)scrollOffset / (float)this.$state.getPageSizeWithSpacing$foundation();
                this.$state.snapToItem$foundation(index2, finalOffset);
            }

            public float calculateDistanceTo(int targetIndex, int targetItemOffset) {
                return (float)(targetIndex - this.$state.getCurrentPage()) * (float)this.getVisibleItemsAverageSize() + (float)targetItemOffset;
            }

            @Nullable
            public Object scroll(@NotNull Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
                Object object = ScrollableState.scroll$default(this.$state, null, block, $completion, 1, null);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            public int getVisibleItemsAverageSize() {
                return this.$state.getPageSize$foundation() + this.$state.getPageSpacing$foundation();
            }
        };
    }
}

