/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.runtime.Immutable;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/animation/core/CubicBezierEasing;", "Landroidx/compose/animation/core/Easing;", "a", "", "b", "c", "d", "(FFFF)V", "equals", "", "other", "", "evaluateCubic", "m", "hashCode", "", "transform", "fraction", "animation-core"})
@Immutable
public final class CubicBezierEasing
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    public static final int $stable;

    public CubicBezierEasing(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        if (!(!Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d))) {
            boolean bl = false;
            String string = "Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final float evaluateCubic(float a, float b, float m) {
        return (float)3 * a * (1.0f - m) * (1.0f - m) * m + (float)3 * b * (1.0f - m) * m * m + m * m * m;
    }

    @Override
    public float transform(float fraction) {
        if (fraction > 0.0f && fraction < 1.0f) {
            float start = 0.0f;
            float end = 1.0f;
            while (true) {
                float midpoint;
                float estimate;
                if (Math.abs(fraction - (estimate = this.evaluateCubic(this.a, this.c, midpoint = (start + end) / (float)2))) < 0.001f) {
                    return this.evaluateCubic(this.b, this.d, midpoint);
                }
                if (estimate < fraction) {
                    start = midpoint;
                    continue;
                }
                end = midpoint;
            }
        }
        return fraction;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)other).d;
    }

    public int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }
}

