/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.SpringSimulationKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0002J-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0004R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\u0004\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Landroidx/compose/animation/core/SpringSimulation;", "", "finalPosition", "", "(F)V", "dampedFreq", "", "value", "dampingRatio", "getDampingRatio", "()F", "setDampingRatio", "getFinalPosition", "setFinalPosition", "gammaMinus", "gammaPlus", "initialized", "", "naturalFreq", "stiffness", "getStiffness", "setStiffness", "getAcceleration", "lastDisplacement", "lastVelocity", "init", "", "updateValues", "Landroidx/compose/animation/core/Motion;", "timeElapsed", "", "updateValues-IJZedt4$animation_core", "(FFJ)J", "animation-core"})
@StabilityInferred(parameters=0)
public final class SpringSimulation {
    private float finalPosition;
    private double naturalFreq;
    private boolean initialized;
    private double gammaPlus;
    private double gammaMinus;
    private double dampedFreq;
    private float dampingRatio;
    public static final int $stable = 8;

    public SpringSimulation(float finalPosition) {
        this.finalPosition = finalPosition;
        this.naturalFreq = Math.sqrt(50.0);
        this.dampingRatio = 1.0f;
    }

    public final float getFinalPosition() {
        return this.finalPosition;
    }

    public final void setFinalPosition(float f) {
        this.finalPosition = f;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    public final void setStiffness(float value) {
        if (this.getStiffness() <= 0.0f) {
            throw new IllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt(value);
        this.initialized = false;
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final void setDampingRatio(float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = value;
        this.initialized = false;
    }

    public final float getAcceleration(float lastDisplacement, float lastVelocity) {
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double k = this.naturalFreq * this.naturalFreq;
        double c = 2.0 * this.naturalFreq * (double)this.dampingRatio;
        return (float)(-k * (double)adjustedDisplacement - c * (double)lastVelocity);
    }

    private final void init() {
        if (this.initialized) {
            return;
        }
        if (this.finalPosition == SpringSimulationKt.getUNSET()) {
            throw new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
        }
        double dampingRatioSquared = (double)this.dampingRatio * (double)this.dampingRatio;
        if (this.dampingRatio > 1.0f) {
            this.gammaPlus = (double)(-this.dampingRatio) * this.naturalFreq + this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
            this.gammaMinus = (double)(-this.dampingRatio) * this.naturalFreq - this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
        } else if (this.dampingRatio >= 0.0f && this.dampingRatio < 1.0f) {
            this.dampedFreq = this.naturalFreq * Math.sqrt(1.0 - dampingRatioSquared);
        }
        this.initialized = true;
    }

    public final long updateValues-IJZedt4$animation_core(float lastDisplacement, float lastVelocity, long timeElapsed) {
        this.init();
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)timeElapsed / 1000.0;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        if (this.dampingRatio > 1.0f) {
            double coeffA = (double)adjustedDisplacement - (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            double coeffB = (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            displacement = coeffA * Math.exp(this.gammaMinus * deltaT) + coeffB * Math.exp(this.gammaPlus * deltaT);
            currentVelocity = coeffA * this.gammaMinus * Math.exp(this.gammaMinus * deltaT) + coeffB * this.gammaPlus * Math.exp(this.gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.exp(-this.naturalFreq * deltaT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.exp(-this.naturalFreq * deltaT) * -this.naturalFreq + coeffB * Math.exp(-this.naturalFreq * deltaT);
        } else {
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / this.dampedFreq * ((double)this.dampingRatio * this.naturalFreq * (double)adjustedDisplacement + (double)lastVelocity);
            displacement = Math.exp((double)(-this.dampingRatio) * this.naturalFreq * deltaT) * ((double)cosCoeff * Math.cos(this.dampedFreq * deltaT) + sinCoeff * Math.sin(this.dampedFreq * deltaT));
            currentVelocity = displacement * -this.naturalFreq * (double)this.dampingRatio + Math.exp((double)(-this.dampingRatio) * this.naturalFreq * deltaT) * (-this.dampedFreq * (double)cosCoeff * Math.sin(this.dampedFreq * deltaT) + this.dampedFreq * sinCoeff * Math.cos(this.dampedFreq * deltaT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        return SpringSimulationKt.Motion(newValue, newVelocity);
    }
}

