package com.candata.login;

import java.io.File;

import com.candata.login.utils.DefaultTrustManager;
import com.candata.login.utils.Platform;
import com.candata.login.utils.Version;
import com.candata.login.zoo.LoginStarter;

public class Start
{
	public static void main(String[] args) throws Throwable
	{
		setApplicationDirectory();
		System.setProperty("candata.launcher.version", Version.VERSION);
		new Start().init(args);
		System.exit(0);
	}

	protected static void processArguments(String[] args)
	{
		if (args == null || args.length == 0)
		{
		}
	}

	protected void init(String[] args) throws Throwable
	{
		DefaultTrustManager.configure();
		processArguments(args);
		new LoginStarter().start();
	}

	protected static void setApplicationDirectory()
	{
		if (Platform.isOSX())
		{
			File rootJavaDir = new File(System.getProperty("user.dir"));
			if (!rootJavaDir.exists() || rootJavaDir.getParentFile() == null)
			{
				return;
			}
			File appDir = rootJavaDir.getParentFile().getParentFile();
			System.setProperty("candata.application.dir", appDir.getAbsolutePath());
		}
	}
}
