package com.candata.login.zoo;

import static com.candata.login.utils.Version.VERSION;
import static com.candata.login.zoo.utils.Properties.CACHE_CLEARED;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.candata.login.utils.Platform;
import com.candata.login.zoo.utils.ColorFactory;
import com.candata.login.zoo.utils.WindowsUtils;
import com.candata.login.zoo.widgets.ImageWidget;
import com.candata.login.zoo.widgets.OKCancelButtons;
import com.candata.login.zoo.widgets.ProgressIndicator;
import com.candata.login.zoo.widgets.listeners.MoveShellListener;

public class LoginShell extends Shell
{
	/**
	 * Create the shell.
	 * @param display
	 */
	public LoginShell(Display display)
	{
		super(display, SWT.TOOL | SWT.BORDER | SWT.ON_TOP);
		createContents();
	}

	/**
	 * Create contents of the shell.
	 */
	protected void createContents()
	{
		setText("Candata");
		setSize(489, 223);

		final Display dpy = getDisplay();
		Color whiteColor = dpy.getSystemColor(Display.isSystemDarkTheme() ? SWT.COLOR_WIDGET_LIGHT_SHADOW : SWT.COLOR_WHITE);// SWT.COLOR_WIDGET_BACKGROUND);
		if (Platform.isGTK())
		{
			setImages(new Image[] { getImage("16x16.ico"), getImage("24x24.ico"), getImage("48x48.ico") });
		}
		else if (Platform.isOSX())
		{
			setImage(getImage("mac-os-icon.png"));
		}
		else
		{
			setImages(new Image[] { getImage("16x16.ico"),
					getImage("24x24.ico"), getImage("32x32.ico"),
					getImage("48x48.ico") });
		}
		final GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.verticalSpacing = 2;
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		setLayout(gridLayout);
		addTraverseListener(event -> {
			if (event.detail == SWT.TRAVERSE_ESCAPE)
			{
				//				exitApplication();
			}
		});
		titleComposite = new Composite(this, SWT.NONE);
		titleComposite.setBackground(whiteColor);
		WindowsUtils.ignoreDarkModeSkin(titleComposite);
		final GridData gd_titleComposite = new GridData(SWT.FILL, SWT.TOP, true, false);
		gd_titleComposite.widthHint = 450;
		gd_titleComposite.heightHint = 70;
		titleComposite.setLayoutData(gd_titleComposite);
		final GridLayout gl_titleComposite = new GridLayout(2, false);
		gl_titleComposite.marginBottom = Platform.isOSX() ? 0 : 6;
		gl_titleComposite.verticalSpacing = 1;
		gl_titleComposite.marginRight = 0;
		gl_titleComposite.marginLeft = 10;
		if (Platform.isOSX())
		{
			gl_titleComposite.marginTop = 3;
		}
		titleComposite.setLayout(gl_titleComposite);

		ImageWidget logoImageWidget = new ImageWidget(titleComposite, getAnimatedImage("logo.pngz"));
		logoImageWidget.setSingleLoop();
		logoImageWidget.setVerticalMargin(-8);
		final GridData gd_logoImageWidget = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 3);
		gd_logoImageWidget.heightHint = 71;
		gd_logoImageWidget.minimumWidth = 200;
		gd_logoImageWidget.widthHint = 200;
		gd_logoImageWidget.verticalAlignment = SWT.TOP;
		logoImageWidget.setLayoutData(gd_logoImageWidget);

		logoImageWidget.setCursor(logoImageWidget.getDisplay().getSystemCursor(SWT.CURSOR_HAND));
		logoImageWidget.setToolTipText("Double-Click to go to candata.com");
		logoImageWidget.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseUp(MouseEvent event)
			{
				if (event.button == 3)
				{
					logoImageWidget.loop();
				}
			}

			@Override
			public void mouseDoubleClick(MouseEvent event)
			{
				Program.launch("https://www.candata.com");
			}
		});
		logoImageWidget.play();

		copyrightComposite = new Composite(titleComposite, SWT.NONE);
		copyrightComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		copyrightComposite.setBackground(whiteColor);
		WindowsUtils.ignoreDarkModeSkin(copyrightComposite);
		GridLayout gl_copyrightComposite = new GridLayout(1, false);
		gl_copyrightComposite.verticalSpacing = 0;
		gl_copyrightComposite.marginWidth = 0;
		gl_copyrightComposite.marginHeight = 0;
		copyrightComposite.setLayout(gl_copyrightComposite);

		copyrightLabel = new Label(copyrightComposite, SWT.NONE);
		if (Display.isSystemDarkTheme())
		{
			copyrightLabel.setForeground(dpy.getSystemColor(SWT.COLOR_BLACK));
		}
		WindowsUtils.ignoreDarkModeSkin(copyrightLabel);
		GridData gd_copyrightLabel = new GridData(SWT.RIGHT, SWT.BOTTOM, true, false, 1, 1);
		gd_copyrightLabel.verticalIndent = 5;
		copyrightLabel.setLayoutData(gd_copyrightLabel);
		copyrightLabel.setText("\u00A9 " + LocalDate.now().getYear() + " Candata Global SEZC");

		FontData fontData = copyrightLabel.getFont().getFontData()[0];
		labelFont = new Font(dpy, new FontData(fontData.getName(), Platform.isWindows() ? 7 : 9, fontData.getStyle()));
		copyrightLabel.setFont(labelFont);
		copyrightLabel.setBackground(whiteColor);

		versionLabel = new Label(titleComposite, SWT.NONE);
		if (Display.isSystemDarkTheme())
		{
			versionLabel.setForeground(dpy.getSystemColor(SWT.COLOR_BLACK));
		}
		WindowsUtils.ignoreDarkModeSkin(versionLabel);
		versionLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, true, true, 1, 1));
		versionLabel.setText("v" + VERSION);
		versionLabel.setFont(labelFont);
		versionLabel.setBackground(whiteColor);
		new Label(titleComposite, SWT.NONE);

		contentComposite = new Composite(this, SWT.None);
		contentComposite.setVisible(true);
		contentComposite.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, false));
		sl_contentComposite = new StackLayout();
		sl_contentComposite.marginHeight = 5;
		contentComposite.setLayout(sl_contentComposite);

		emailComposite = new Composite(contentComposite, SWT.NONE);
		emailComposite.setLayout(new GridLayout(2, false));
		buildEmailComposite();

		loginFrameComposite = new Composite(contentComposite, SWT.NONE);
		GridLayout gl_loginFrameComposite = new GridLayout(1, false);
		gl_loginFrameComposite.marginWidth = 0;
		gl_loginFrameComposite.marginHeight = 0;
		loginFrameComposite.setLayout(gl_loginFrameComposite);

		mainLoginComposite = new Composite(loginFrameComposite, SWT.None);
		mainLoginComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		mainLoginComposite.setLayout(new GridLayout(3, false));

		final Label usernameLabel = new Label(mainLoginComposite, SWT.NONE);
		GridData gd_usernameLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_usernameLabel.widthHint = 90;
		usernameLabel.setLayoutData(gd_usernameLabel);
		usernameLabel.setText("Email");

		emailLoginLabelComposite = new Composite(mainLoginComposite, SWT.NONE);
		GridData gd_emailLoginLabelComposite = new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1);
		gd_emailLoginLabelComposite.widthHint = 180;
		emailLoginLabelComposite.setLayoutData(gd_emailLoginLabelComposite);
		GridLayout gl_emailLoginLabelComposite = new GridLayout(3, false);
		gl_emailLoginLabelComposite.marginHeight = 0;
		gl_emailLoginLabelComposite.marginWidth = 0;
		emailLoginLabelComposite.setLayout(gl_emailLoginLabelComposite);

		loginEmailLabel = new Label(emailLoginLabelComposite, SWT.NONE);
		loginEmailLabel.setText("nobody@company.com");

		switchUserLabel = new Label(emailLoginLabelComposite, SWT.NONE);
		GridData gd_switchUserLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_switchUserLabel.heightHint = 16;
		gd_switchUserLabel.widthHint = 16;
		switchUserLabel.setLayoutData(gd_switchUserLabel);
		switchUserLabel.setImage(getImage("leftArrow.png"));
		switchUserLabel.setToolTipText("Change the email address used to login\tF2");
		switchUserLabel.setData(MoveShellListener.IGNORE_MOVE_KEY, true);

		statusErrorComposite = new Composite(emailLoginLabelComposite, SWT.NONE);
		statusErrorComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		statusErrorComposite.setSize(121, 18);
		statusStackLayout = new StackLayout();
		statusErrorComposite.setLayout(statusStackLayout);
		validSupportUserComposite = new Composite(statusErrorComposite, SWT.None);
		GridLayout gl_validSupportUserComposite = new GridLayout(1, false);
		gl_validSupportUserComposite.marginHeight = 0;
		gl_validSupportUserComposite.marginWidth = 0;
		validSupportUserComposite.setLayout(gl_validSupportUserComposite);

		validSupportUserLabel = new Label(validSupportUserComposite, SWT.NONE);
		GridData gd_validSupportUserLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_validSupportUserLabel.heightHint = 16;
		gd_validSupportUserLabel.widthHint = 16;
		validSupportUserLabel.setLayoutData(gd_validSupportUserLabel);
		validSupportUserLabel.setImage(getImage("success.png"));
		userValidatingComposite = new Composite(statusErrorComposite, SWT.None);
		GridLayout gl_userValidatingComposite = new GridLayout(1, false);
		gl_userValidatingComposite.marginHeight = 0;
		gl_userValidatingComposite.marginWidth = 0;
		userValidatingComposite.setLayout(gl_userValidatingComposite);
		userValidatingImageWidget = new ImageWidget(userValidatingComposite, getAnimatedImage("waitIcon.gif"));
		GridData gd_userValidatingImageWidget = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_userValidatingImageWidget.heightHint = 16;
		gd_userValidatingImageWidget.widthHint = 16;
		userValidatingImageWidget.setLayoutData(gd_userValidatingImageWidget);

		userNameErrorLabel = new Label(statusErrorComposite, SWT.NONE);
		userNameErrorLabel.setText("Username required");
		userNameErrorLabel.setForeground(new Color(dpy, 255, 0, 0));
		userNameErrorLabel.setVisible(false);

		statusComposite = new Composite(statusErrorComposite, SWT.NONE);
		final GridLayout gd_statusComposite = new GridLayout(2, false);
		gd_statusComposite.marginHeight = 0;
		gd_statusComposite.marginWidth = 0;
		statusComposite.setLayout(gd_statusComposite);
		statusComposite.setLayoutData(new GridData(SWT.LEFT, SWT.DEFAULT, true, false));

		loginMessageLabel = new Label(statusComposite, SWT.NONE);
		loginMessageLabel.setText("Status Message\u2026");
		loginMessageLabel.setForeground(new Color(dpy, 0, 0, 255));
		loginMessageLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		loginMessageIconLabel = new Label(statusComposite, SWT.None);
		loginMessageIconLabel.setBackgroundImage(getImage(FAIL_IMAGE_NAME));
		loginMessageIconLabel.setLayoutData(new GridData(18, 18));
		statusStackLayout.topControl = statusComposite;

		statusStackLayout.topControl = statusComposite;
		loginMessageLabel.setText("Authentication Failed");
		loginMessageLabel.setToolTipText("Authentication Failed\n");

		loginTypeStackComposite = new Composite(mainLoginComposite, SWT.NONE);
		loginTypeStackCompositeLayout = new StackLayout();
		loginTypeStackComposite.setLayout(loginTypeStackCompositeLayout);
		loginTypeStackComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		loginComposite = new Composite(loginTypeStackComposite, SWT.NONE);
		GridLayout gl_loginComposite = new GridLayout(3, false);
		gl_loginComposite.marginHeight = 0;
		gl_loginComposite.marginWidth = 0;
		gl_loginComposite.marginBottom = 7;
		loginComposite.setLayout(gl_loginComposite);
		loginTypeStackCompositeLayout.topControl = loginComposite;

		lblCompany = new Label(loginComposite, SWT.NONE);
		GridData gd_lblCompany = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblCompany.widthHint = 90;
		lblCompany.setLayoutData(gd_lblCompany);
		lblCompany.setText("Company");

		userServerStackedComposite = new Composite(loginComposite, SWT.NONE);
		GridData gd_userServerStackedComposite = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_userServerStackedComposite.widthHint = 160;
		userServerStackedComposite.setLayoutData(gd_userServerStackedComposite);
		userServerStackedCompositeLayout = new StackLayout();
		userServerStackedComposite.setLayout(userServerStackedCompositeLayout);

		userServerCombo = new Combo(userServerStackedComposite, SWT.READ_ONLY);
		userServerCombo.addVerifyListener(event -> event.text = event.text.toLowerCase());
		userServerLabelComposite = new Composite(userServerStackedComposite, SWT.None);
		GridLayout gl_userServerLabelComposite = new GridLayout(1, false);
		gl_userServerLabelComposite.marginHeight = 0;
		gl_userServerLabelComposite.marginWidth = 0;
		userServerLabelComposite.setLayout(gl_userServerLabelComposite);
		userServerLabel = new Label(userServerLabelComposite, SWT.NONE);
		userServerLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, true, 1, 1));
		//TODO:fix
		//		serverCombo.addKeyListener(serverComboKeyListener);
		//		serverCombo.addSelectionListener(serverComboSelectionListener);

		connectedStatusComposite = new Composite(loginComposite, SWT.NONE);
		connectedStatusCompositeLayout = new StackLayout();
		connectedStatusComposite.setLayout(connectedStatusCompositeLayout);

		failedComposite = new Composite(connectedStatusComposite, SWT.NONE);
		GridLayout gl_failedComposite = new GridLayout(2, false);
		gl_failedComposite.marginHeight = 0;
		gl_failedComposite.marginWidth = 0;
		failedComposite.setLayout(gl_failedComposite);

		failedIconLabel = new Label(failedComposite, SWT.NONE);
		GridData gd_failedIconLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_failedIconLabel.heightHint = 16;
		gd_failedIconLabel.widthHint = 16;
		failedIconLabel.setLayoutData(gd_failedIconLabel);
		failedIconLabel.setImage(getImage(FAIL_IMAGE_NAME));

		failedIconLabel = new Label(failedComposite, SWT.NONE);
		failedIconLabel.setText("Can't connect");
		failedIconLabel.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));

		connectedComposite = new Composite(connectedStatusComposite, SWT.NONE);
		connectedComposite.setForeground(ColorFactory.getColor(0, 204, 51));
		GridLayout gl_connectedComposite = new GridLayout(2, false);
		gl_connectedComposite.marginHeight = 0;
		gl_connectedComposite.marginWidth = 0;
		connectedComposite.setLayout(gl_connectedComposite);

		connectedIconLabel = new Label(connectedComposite, SWT.NONE);
		GridData gd_connectedIconLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_connectedIconLabel.heightHint = 16;
		gd_connectedIconLabel.widthHint = 16;
		connectedIconLabel.setLayoutData(gd_connectedIconLabel);
		connectedIconLabel.setImage(getImage("success.png"));

		connectedLabel = new Label(connectedComposite, SWT.NONE);
		connectedLabel.setForeground(ColorFactory.getColor(102, 204, 102));
		connectedLabel.setBounds(0, 0, 59, 14);

		new Label(loginComposite, SWT.NONE);
		userEmailResultComposite = new Composite(loginComposite, SWT.NONE);
		userEmailResultComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		userEmailResultCompositeLayout = new StackLayout();
		userEmailResultComposite.setLayout(userEmailResultCompositeLayout);

		userFailedComposite = new Composite(userEmailResultComposite, SWT.None);
		GridLayout gl_userFailedComposite = new GridLayout(2, false);
		gl_userFailedComposite.marginHeight = 0;
		gl_userFailedComposite.marginWidth = 0;
		userFailedComposite.setLayout(gl_userFailedComposite);
		userFailedIconLabel = new Label(userFailedComposite, SWT.NONE);
		GridData gd_userFailedIconLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_userFailedIconLabel.heightHint = 16;
		gd_userFailedIconLabel.widthHint = 16;
		userFailedIconLabel.setLayoutData(gd_userFailedIconLabel);
		userFailedIconLabel.setImage(getImage(FAIL_IMAGE_NAME));

		userFailedLabel = new Label(userFailedComposite, SWT.NONE);
		userFailedLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		userFailedLabel.setText(AUTHENTICATION_FAILED);
		userFailedLabel.setForeground(userFailedLabel.getDisplay().getSystemColor(SWT.COLOR_RED));

		userVerifyingEmailComposite = new Composite(userEmailResultComposite, SWT.NONE);
		GridLayout gl_userVerifyingEmailComposite = new GridLayout(2, false);
		gl_userVerifyingEmailComposite.marginHeight = 0;
		gl_userVerifyingEmailComposite.marginWidth = 0;
		userVerifyingEmailComposite.setLayout(gl_userVerifyingEmailComposite);
		userVerifyingEmailImageWidget = new ImageWidget(userVerifyingEmailComposite, getAnimatedImage("waitIcon.gif"));
		GridData gd_userVerifyingEmailImageWidget = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_userVerifyingEmailImageWidget.heightHint = 18;
		gd_userVerifyingEmailImageWidget.widthHint = 18;
		userVerifyingEmailImageWidget.setLayoutData(gd_userVerifyingEmailImageWidget);
		userVerifyingEmailImageWidget.setSize(18, 18);
		userVerifyingEmailLabel = new Label(userVerifyingEmailComposite, SWT.NONE);
		userVerifyingEmailLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		userVerifyingEmailLabel.setSize(56, 14);
		userVerifyingEmailLabel.setText("Verifying");

		userVerifiedEmailComposite = new Composite(userEmailResultComposite, SWT.NONE);
		GridLayout gl_userVerifiedEmailComposite = new GridLayout(2, false);
		gl_userVerifiedEmailComposite.marginHeight = 0;
		gl_userVerifiedEmailComposite.marginWidth = 0;
		userVerifiedEmailComposite.setLayout(gl_userVerifiedEmailComposite);

		userVerifiedEmailIconLabel = new Label(userVerifiedEmailComposite, SWT.NONE);
		GridData gd_userVerifiedEmailIconLabel = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_userVerifiedEmailIconLabel.heightHint = 16;
		gd_userVerifiedEmailIconLabel.widthHint = 16;
		userVerifiedEmailIconLabel.setLayoutData(gd_userVerifiedEmailIconLabel);
		userVerifiedEmailIconLabel.setImage(getImage("yesCheck.png"));

		userVerifiedLabel = new Label(userVerifiedEmailComposite, SWT.NONE);
		userVerifiedLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		userVerifiedLabel.setText("Verified");
		//		//		verifiedLabel.setForeground(verifiedLabel.getDisplay().getSystemColor(SWT.COLOR_GREEN));
		//
		//
		supportLoginComposite = new Composite(loginTypeStackComposite, SWT.NONE);
		GridLayout gl_supportLoginComposite = new GridLayout(4, false);
		gl_supportLoginComposite.marginHeight = 0;
		gl_supportLoginComposite.marginWidth = 0;
		supportLoginComposite.setLayout(gl_supportLoginComposite);

		Label lblserver = new Label(supportLoginComposite, SWT.NONE);
		lblserver.setText("&Server");

		supportServerCombo = new Combo(supportLoginComposite, SWT.NONE);
		supportServerCombo.addVerifyListener(event -> event.text = event.text.toLowerCase());
		GridData gd_supportServerCombo = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_supportServerCombo.widthHint = 180;
		supportServerCombo.setLayoutData(gd_supportServerCombo);

		Label lblInstance = new Label(supportLoginComposite, SWT.NONE);
		lblInstance.setText("I&nstance");

		Composite instanceComposite = new Composite(supportLoginComposite, SWT.None);
		GridLayout gl_instanceComposite = new GridLayout(1, false);
		gl_instanceComposite.marginWidth = 0;
		gl_instanceComposite.marginHeight = 0;
		gl_instanceComposite.verticalSpacing = 0;
		instanceComposite.setLayout(gl_instanceComposite);
		GridData gd_instanceComposite = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 3);
		gd_instanceComposite.widthHint = 100;
		instanceComposite.setLayoutData(gd_instanceComposite);

		supportInstanceCombo = new Combo(instanceComposite, SWT.READ_ONLY);
		supportInstanceCombo.setItems("Latest");
		GridData gd_supportInstanceCombo = new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1);
		gd_supportInstanceCombo.widthHint = 100;
		supportInstanceCombo.setLayoutData(gd_supportInstanceCombo);
		supportInstanceCombo.select(0);

		namespaceLabel = new Label(instanceComposite, SWT.NONE);
		namespaceLabel.setText("test");
		namespaceLabel.setFont(labelFont);
		GridData gd_namespaceLabel = new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1);
		gd_namespaceLabel.horizontalIndent = 5;
		namespaceLabel.setLayoutData(gd_namespaceLabel);

		lblEnvironment = new Label(supportLoginComposite, SWT.NONE);
		GridData gd_lblEnvironment = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblEnvironment.widthHint = 100;
		lblEnvironment.setLayoutData(gd_lblEnvironment);
		lblEnvironment.setText("Environment");

		Composite environmentComposite = new Composite(supportLoginComposite, SWT.NONE);
		GridLayout gl_environmentComposite = new GridLayout(2, false);
		gl_environmentComposite.marginHeight = 0;
		gl_environmentComposite.marginWidth = 0;
		environmentComposite.setLayout(gl_environmentComposite);

		btnProduction = new Button(environmentComposite, SWT.RADIO);
		btnProduction.setSelection(true);
		btnProduction.setText("Production");

		btnTest = new Button(environmentComposite, SWT.RADIO);
		btnTest.setText("Test");
		new Label(supportLoginComposite, SWT.NONE);

		Label impersonateLabel = new Label(supportLoginComposite, SWT.CHECK);
		impersonateLabel.setText("&Impersonate");

		supportImpersonateCombo = new Combo(supportLoginComposite, SWT.READ_ONLY);

		GridData gd_supportImpersonateCombo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_supportImpersonateCombo.widthHint = 149;
		supportImpersonateCombo.setLayoutData(gd_supportImpersonateCombo);
		supportImpersonateCombo.select(0);
		new Label(supportLoginComposite, SWT.NONE);
		sl_contentComposite.topControl = emailComposite;

		progressComposite = new Composite(contentComposite, SWT.None);
		createProgressComposite(progressComposite);

		GridData gd_userNameErrorLabel = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd_userNameErrorLabel.widthHint = 150;

		buttonComposite = new Composite(this, SWT.NONE);
		buttonComposite.setVisible(true);
		buttonComposite.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		GridLayout gl_buttonComposite = new GridLayout(3, false);
		gl_buttonComposite.marginBottom = 5;
		gl_buttonComposite.marginHeight = 0;
		gl_buttonComposite.marginWidth = 0;
		buttonComposite.setLayout(gl_buttonComposite);

		Label separator = new Label(buttonComposite, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData gd_separator = new GridData(GridData.FILL_HORIZONTAL);
		gd_separator.horizontalSpan = 3;
		separator.setLayoutData(gd_separator);

		leftButtonComposite = new Composite(buttonComposite, SWT.None);
		leftButtonCompositeLayout = new StackLayout();
		leftButtonCompositeLayout.marginWidth = 5;
		leftButtonComposite.setLayout(leftButtonCompositeLayout);
		leftButtonComposite.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true));

		cacheClearedComposite = new Composite(buttonComposite, SWT.NONE);
		cacheClearedComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		GridLayout gl_cacheClearedComposite = new GridLayout(2, false);
		gl_cacheClearedComposite.marginHeight = 0;
		gl_cacheClearedComposite.marginWidth = 0;
		cacheClearedComposite.setLayout(gl_cacheClearedComposite);

		cacheSuccessfullyClearedIconLabel = new Label(cacheClearedComposite, SWT.NONE);
		GridData gd_cacheSuccessfullyClearedIconLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_cacheSuccessfullyClearedIconLabel.heightHint = 16;
		gd_cacheSuccessfullyClearedIconLabel.widthHint = 16;
		cacheSuccessfullyClearedIconLabel.setLayoutData(gd_cacheSuccessfullyClearedIconLabel);
		cacheSuccessfullyClearedIconLabel.setImage(getImage("yesCheck.png"));

		cacheSuccessfullyClearedLabel = new Label(cacheClearedComposite, SWT.NONE);
		cacheSuccessfullyClearedLabel.setText("Cache successfully cleared");
		if (System.getProperty(CACHE_CLEARED) == null)
		{
			cacheClearedComposite.setVisible(false);
		}
		System.clearProperty(CACHE_CLEARED);
		final Composite rightButtonComposite = new Composite(buttonComposite, SWT.None);
		GridLayout gl_rightButtonComposite = new GridLayout(1, true);
		gl_rightButtonComposite.marginHeight = 0;
		rightButtonComposite.setLayout(gl_rightButtonComposite);
		rightButtonComposite.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, true));

		okCancelButtons = new OKCancelButtons(rightButtonComposite, SWT.NONE);

		rememberMeButton = new Button(leftButtonComposite, SWT.CHECK);
		rememberMeButton.setText("&Remember Me");
		rememberMeButton.setVisible(false);

		proxyLink = new Link(leftButtonComposite, SWT.NONE);
		proxyLink.setText("<a>Proxy Settings\u2026</a>");
		leftButtonCompositeLayout.topControl = proxyLink;
	}

	@Override
	public void dispose()
	{
		if (labelFont != null)
		{
			labelFont.dispose();
		}
		images.values()
				.stream()
				.forEach(Image::dispose);
		mainProgressBar.done();
		super.dispose();
	}

	protected void buildEmailComposite()
	{
		Label emailLabel = new Label(emailComposite, SWT.NONE);
		GridData gd_emailLabel = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1);
		gd_emailLabel.widthHint = 80;
		emailLabel.setLayoutData(gd_emailLabel);
		emailLabel.setText("&Email");

		emailText = new Text(emailComposite, SWT.BORDER);
		GridData gd_emailText = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_emailText.widthHint = 220;
		emailText.setLayoutData(gd_emailText);
		emailText.addVerifyListener(e -> e.text = e.text.toLowerCase());

		new Label(emailComposite, SWT.NONE);

		emailResultComposite = new Composite(emailComposite, SWT.NONE);
		emailResultComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		emailResultCompositeLayout = new StackLayout();
		emailResultComposite.setLayout(emailResultCompositeLayout);

		verifyingEmailComposite = new Composite(emailResultComposite, SWT.NONE);
		GridLayout gl_verifyingEmailComposite = new GridLayout(2, false);
		gl_verifyingEmailComposite.marginHeight = 0;
		gl_verifyingEmailComposite.marginWidth = 0;
		verifyingEmailComposite.setLayout(gl_verifyingEmailComposite);
		verifyingEmailImageWidget = new ImageWidget(verifyingEmailComposite, getAnimatedImage("waitIcon.gif"));
		GridData gd_verifyingEmailImageWidget = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_verifyingEmailImageWidget.heightHint = 18;
		gd_verifyingEmailImageWidget.widthHint = 18;
		verifyingEmailImageWidget.setLayoutData(gd_verifyingEmailImageWidget);
		verifyingEmailImageWidget.setSize(18, 18);
		verifyingEmailLabel = new Label(verifyingEmailComposite, SWT.NONE);
		verifyingEmailLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		verifyingEmailLabel.setSize(56, 14);
		verifyingEmailLabel.setText("Verifying");

		verifiedEmailComposite = new Composite(emailResultComposite, SWT.NONE);
		GridLayout gl_verifiedEmailComposite = new GridLayout(2, false);
		gl_verifiedEmailComposite.marginHeight = 0;
		gl_verifiedEmailComposite.marginWidth = 0;
		verifiedEmailComposite.setLayout(gl_verifiedEmailComposite);

		verifiedEmailIconLabel = new Label(verifiedEmailComposite, SWT.NONE);
		GridData gd_verifiedEmailIconLabel = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_verifiedEmailIconLabel.heightHint = 16;
		gd_verifiedEmailIconLabel.widthHint = 16;
		verifiedEmailIconLabel.setLayoutData(gd_verifiedEmailIconLabel);
		verifiedEmailIconLabel.setImage(getImage("yesCheck.png"));

		verifiedLabel = new Label(verifiedEmailComposite, SWT.NONE);
		verifiedLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		verifiedLabel.setText("Verified");
		//		verifiedLabel.setForeground(verifiedLabel.getDisplay().getSystemColor(SWT.COLOR_GREEN));

		invalidEmailComposite = new Composite(emailResultComposite, SWT.NONE);
		GridLayout gl_invalidEmailComposite = new GridLayout(2, false);
		gl_invalidEmailComposite.marginHeight = 0;
		gl_invalidEmailComposite.marginWidth = 0;
		invalidEmailComposite.setLayout(gl_invalidEmailComposite);

		invalidEmailIconLabel = new Label(invalidEmailComposite, SWT.NONE);
		GridData gd_invalidEmailIconLabel = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_invalidEmailIconLabel.heightHint = 15;
		gd_invalidEmailIconLabel.widthHint = 15;
		invalidEmailIconLabel.setLayoutData(gd_invalidEmailIconLabel);
		invalidEmailIconLabel.setImage(getImage(FAIL_IMAGE_NAME));

		invalidEmailLabel = new Label(invalidEmailComposite, SWT.NONE);
		invalidEmailLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		invalidEmailLabel.setText(INVALID_EMAIL);
		invalidEmailLabel.setForeground(invalidEmailIconLabel.getDisplay().getSystemColor(SWT.COLOR_RED));
		verifyingEmailImageWidget.play();
	}

	void createProgressComposite(Composite progressComposite)
	{
		progressComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		progressComposite.setLayout(new GridLayout(2, false));
		GridData gd_userNameErrorLabel = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd_userNameErrorLabel.widthHint = 150;

		taskLabel = new Label(progressComposite, SWT.NONE);
		taskLabel.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, true, 2, 1));
		taskLabel.setText("");
		mainProgressBar = new ProgressIndicator(progressComposite);
		mainProgressBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		// mainProgressBar.beginAnimatedTask();
		progressImageWidget = new ImageWidget(progressComposite, getAnimatedImage("waitIcon.gif"));
		GridData gd_progressImageWidget = new GridData(18, 18);
		gd_progressImageWidget.verticalAlignment = SWT.TOP;
		progressImageWidget.setLayoutData(gd_progressImageWidget);
		progressImageWidget.play();
		progressLabel = new Label(progressComposite, SWT.NONE);
		progressLabel.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1));
		progressLabel.setText("");
	}

	protected Image getImage(String name)
	{
		return images.computeIfAbsent(name, this::doGetImage);
	}

	protected Image doGetImage(String name)
	{
		try (InputStream in = getImageInputStream(name))
		{
			return (in == null) ? null : new Image(Display.getDefault(), in);
		}
		catch (java.io.IOException e)
		{
		}
		return null;
	}

	ImageData[] getAnimatedImage(String name)
	{
		if (name.endsWith(".pngz"))
		{
			try
			{
				return loadPNG(name);
			}
			catch (IOException e)
			{
			}
		}
		try (InputStream in = getImageInputStream(name))
		{
			return (in == null) ? null : new ImageLoader().load(in);
		}
		catch (java.io.IOException e)
		{
		}
		return null;
	}

	ImageData[] loadPNG(String name) throws IOException
	{
		ZipInputStream zis = new ZipInputStream(getImageInputStream(name));
		Map<String, ImageData> imageMap = new HashMap<>();
		// Loop through each entry in the ZIP
		ZipEntry entry;
		while ((entry = zis.getNextEntry()) != null)
		{
			if (!entry.isDirectory() && !entry.getName().startsWith("__"))
			{
				ImageData[] imageData = new ImageLoader().load(zis);
				imageMap.put(entry.getName(), imageData[0]);
			}
		}
		zis.close();
		return imageMap.entrySet()
				.stream()
				.sorted(Comparator.comparing(Entry::getKey))
				.map(Entry::getValue)
				.toArray(ImageData[]::new);
	}

	protected InputStream getImageInputStream(String name)
	{
		if (Login.class.getClassLoader().getResourceAsStream(name) != null)
		{
			return Login.class.getClassLoader().getResourceAsStream(name);
		}
		return Login.class.getClassLoader().getResourceAsStream("images/" + name);
	}

	protected void positionShell()
	{
		pack();
		Rectangle parentRec = getMonitor().getBounds();
		Rectangle rec = getBounds();
		setLocation(parentRec.x + ((parentRec.width - rec.width) / 2), parentRec.y + ((parentRec.height - rec.height) / 2));
	}

	@Override
	protected void checkSubclass()
	{
		// Disable the check that prevents subclassing of SWT components
	}

	Composite titleComposite;
	Composite copyrightComposite;
	Label copyrightLabel;
	Font labelFont;
	Label versionLabel;
	StackLayout sl_contentComposite;
	Composite contentComposite;
	Composite emailComposite;
	Composite loginFrameComposite;
	Composite mainLoginComposite;
	Composite emailLoginLabelComposite;
	Label loginEmailLabel;
	Label switchUserLabel;
	Composite statusErrorComposite;
	StackLayout statusStackLayout;
	Label validSupportUserLabel;
	Composite userValidatingComposite;
	Label userNameErrorLabel;
	Composite statusComposite;
	Composite loginTypeStackComposite;
	Label loginMessageIconLabel;
	Label loginMessageLabel;
	Composite loginComposite;
	Composite validSupportUserComposite;
	ImageWidget userValidatingImageWidget;
	StackLayout loginTypeStackCompositeLayout;
	Label lblCompany;
	Composite userServerStackedComposite;
	Combo userServerCombo;
	Composite userServerLabelComposite;
	StackLayout userServerStackedCompositeLayout;
	Label userServerLabel;
	Composite connectedStatusComposite;
	Composite failedComposite;
	Label failedIconLabel;
	Composite connectedComposite;
	StackLayout connectedStatusCompositeLayout;
	Label connectedIconLabel;
	Label connectedLabel;
	Composite userFailedComposite;
	Label userFailedLabel;
	Composite userEmailResultComposite;
	StackLayout userEmailResultCompositeLayout;
	Label userFailedIconLabel;
	Composite userVerifyingEmailComposite;
	Composite userVerifiedEmailComposite;
	Label userVerifiedEmailIconLabel;
	Label userVerifiedLabel;
	Combo supportInstanceCombo;
	Label namespaceLabel;
	Button btnProduction;
	Label lblEnvironment;
	Combo supportImpersonateCombo;
	Composite progressComposite;
	Composite buttonComposite;
	Composite leftButtonComposite;
	public Composite cacheClearedComposite;
	Label cacheSuccessfullyClearedIconLabel;
	OKCancelButtons okCancelButtons;
	Button rememberMeButton;
	Link proxyLink;
	Text emailText;
	Composite emailResultComposite;
	Composite verifyingEmailComposite;
	ImageWidget verifyingEmailImageWidget;
	Composite invalidEmailComposite;
	Label invalidEmailIconLabel;
	Label verifiedEmailIconLabel;
	Composite verifiedEmailComposite;
	Label verifiedLabel;
	Label verifyingEmailLabel;
	Label invalidEmailLabel;
	Label cacheSuccessfullyClearedLabel;
	StackLayout leftButtonCompositeLayout;
	Composite supportLoginComposite;
	Label taskLabel;
	ProgressIndicator mainProgressBar;
	ImageWidget progressImageWidget;
	Label progressLabel;
	StackLayout emailResultCompositeLayout;
	ImageWidget userVerifyingEmailImageWidget;
	Label userVerifyingEmailLabel;
	Combo supportServerCombo;
	Button btnTest;

	Map<String, Image> images = new HashMap<>();
	static final String INVALID_EMAIL = "Invalid Email";
	static final String AUTHENTICATION_FAILED = "Authentication Failed";
	static final String ERROR_VALIDATING_EMAIL = "Error validating email";
	static final String FAIL_IMAGE_NAME = "error.png";
	static final String BUILD_PREFIX = "build-";
}
