package com.candata.login.zoo.osgi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CandataFormatter extends Formatter
{
	private DateFormat dateFormat;
	private static final String SPACE = " ";
	static final String lineSeparator = System.getProperty("line.separator");

	@Override
	public String format(LogRecord record)
	{
		StringBuilder buf = new StringBuilder(180);

		if (dateFormat == null)
		{
			dateFormat = DateFormat.getDateTimeInstance();
		}
		buf.append(dateFormat.format(new Date(record.getMillis())));
		buf.append(SPACE);
		Throwable throwable = record.getThrown();
		if (throwable != null)
		{
			buf.append(record.getSourceClassName());
			buf.append(SPACE);
			buf.append(record.getSourceMethodName());
		}
		buf.append(": ");
		buf.append(formatMessage(record));
		buf.append(lineSeparator);

		if (throwable != null)
		{
			buf.append(lineSeparator);
			StringWriter sink = new StringWriter();
			throwable.printStackTrace(new PrintWriter(sink, true));
			buf.append(sink.toString());
		}
		return buf.toString();
	}
}
