package com.candata.login.zoo.osgi.tools;

import static java.time.LocalDateTime.now;

import java.time.format.DateTimeFormatter;

import org.osgi.framework.BundleException;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogService;

public class LoggerImpl implements LogListener
{
	private final boolean onlyLogErrors = System.getProperty("candata.eclipse") == null && System.getProperty("ds.loglevel") == null;

	@Override
	public void logged(LogEntry entry)
	{
		if (onlyLogErrors && entry.getLevel() != LogService.LOG_ERROR)
		{
			return;
		}

		Throwable t = entry.getException();
		if (t != null && t instanceof BundleException)
		{
			System.err.println(format.format(now()) + " Error starting bundle " + t.getMessage());
		}
		else
		{
			System.err.println(format.format(now()) + " " + entry.getLevel() + " " + entry.getMessage() + " " + entry.getBundle() + " "
					+ entry.getServiceReference());
			if (t != null)
			{
				System.err.println(format.format(now()) + " " + t.getMessage());
				t.printStackTrace();
			}
		}
	}

	DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
}
