package com.candata.login.zoo.servers;

import org.json.JSONArray;
import org.json.JSONObject;

import io.reactivex.rxjava3.core.Observable;

public record Instance(String namespace, String id, boolean isActive, boolean isReady)
{
	public static Observable<Instance> get(JSONArray data)
	{
		/*
		[
		{
		"namespace": "test",
		"id": "build-450",
		"active": 1,
		"ready": 1
		}
		]
		 */
		return Observable.fromIterable(data)
				.cast(JSONObject.class)
				.map(Instance::parse);
	}

	private static Instance parse(JSONObject data)
	{
		return new Instance(data.optString(NAMESPACE_KEY), data.optString(ID_KEY), data.optInt(ACTIVE_KEY, 0) == 1, data.optInt(READY_KEY, 0) == 1);

	}

	static final String NAMESPACE_KEY = "namespace";
	static final String ID_KEY = "id";
	static final String ACTIVE_KEY = "active";
	static final String READY_KEY = "ready";
}
