package com.candata.login.zoo.utils;

import java.util.HashMap;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColorFactory
{

	public static Color getColor(int r, int g, int b)
	{
		String hex = RGBToHEX(r, g, b);
		Color color = colorMap.get(hex);
		if (color == null || color.isDisposed())
		{
			color = createColor(hex, r, g, b);
		}

		return color;
	}

	protected static RGB HEXToRGB(int hex)
	{
		RGB rgb = new RGB();
		rgb.r = hex >> 16;
		rgb.g = hex >> 8 & 0xFF;
		rgb.b = hex & 0xFF;

		return rgb;
	}

	protected static String RGBToHEX(int r, int g, int b)
	{
		int hex = (r << 16) + (g << 8) + b;
		StringBuffer hexString = new StringBuffer("#");
		hexString.append(Integer.toHexString(hex));
		return hexString.toString();
	}

	private static Color createColor(String hex, int r, int g, int b)
	{
		Color color = new Color(Display.getCurrent(), r, g, b);
		colorMap.put(hex, color);
		return color;
	}

	protected static class RGB
	{
		public double r = 0;
		public double g = 0;
		public double b = 0;
	}
	private static HashMap<String, Color> colorMap = new HashMap<String, Color>();
}
