package com.candata.login.zoo.utils;

import org.eclipse.swt.widgets.Widget;

public class DisplayThread
{
	public static void async(Widget widget, Runnable runnable)
	{
		if (widget == null || widget.isDisposed())
		{
			return;
		}
		widget.getDisplay().asyncExec(() -> {
			if (widget.isDisposed())
			{
				return;
			}
			runnable.run();
		});
	}

	public static void async(Widget widget, int millisDelay, Runnable runnable)
	{
		if (widget == null || widget.isDisposed())
		{
			return;
		}
		widget.getDisplay().timerExec(millisDelay, () -> {
			if (widget.isDisposed())
			{
				return;
			}
			runnable.run();
		});
	}
}
