package com.candata.login.zoo.widgets;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import com.candata.login.utils.Platform;

public class OKCancelButtons extends Composite
{
	protected Button button1;
	protected Button button2;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public OKCancelButtons(Composite parent, int style)
	{
		super(parent, style);
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		gridLayout.numColumns = 2;
		setLayout(gridLayout);
		{
			button1 = new Button(this, SWT.NONE);
			{
				GridData gd_button1 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
				gd_button1.widthHint = 86;
				button1.setLayoutData(gd_button1);
				button1.setText(Platform.isWindows() ? OK : CANCEL);
				// button1.setImage(Platform.isGTK() ?
				// ImageFactory.get(Size16.Cancel) : null);
				button1.setData("name", Platform.isWindows() ? "okButton" : "cancelButton");
			}
		}
		{
			button2 = new Button(this, SWT.NONE);
			{
				GridData gd_button2 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
				gd_button2.widthHint = 86;
				button2.setLayoutData(gd_button2);
				button2.setText(Platform.isWindows() ? CANCEL : OK);
				// button2.setImage(Platform.isGTK() ?
				// ImageFactory.get(Size16.Accept) : null);
				button2.setData("name", Platform.isWindows() ? "cancelButton" : "okButton");
			}
		}
		parent.getShell().setDefaultButton(Platform.isWindows() ? button1 : button2);
		addListeners();
	}

	public Button getOKButton()
	{
		return Platform.isWindows() ? button1 : button2;
	}

	public Button getCancelButton()
	{
		return Platform.isWindows() ? button2 : button1;
	}

	public void setAsOK()
	{
		getOKButton().setText(OK);
	}

	public void setAsNext()
	{
		getOKButton().setText(NEXT);
	}

	protected void addListeners()
	{
		button1.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e)
			{
				fireWidgetSelected(Platform.isWindows() ? okSelectionListeners : cancelSelectionListeners, e);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e)
			{
				fireDefaultWidgetSelected(Platform.isWindows() ? okSelectionListeners : cancelSelectionListeners, e);
			}
		});
		button2.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e)
			{
				fireWidgetSelected(Platform.isWindows() ? cancelSelectionListeners : okSelectionListeners, e);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e)
			{
				fireDefaultWidgetSelected(Platform.isWindows() ? cancelSelectionListeners : okSelectionListeners, e);
			}
		});
		getShell().addTraverseListener(event -> {
			if (event.detail == SWT.TRAVERSE_ESCAPE)
			{
				if (handleCancel())
				{
					event.doit = false;
					event.detail = SWT.None;
				}
			}
		});
		getDisplay().addFilter(SWT.KeyDown, escapeListener);
		getDisplay().addFilter(SWT.Traverse, escapeListener);
		addDisposeListener(arg0 -> removeFilters());
	}

	public void removeFilters()
	{
		getDisplay().removeFilter(SWT.KeyDown, escapeListener);
		getDisplay().removeFilter(SWT.Traverse, escapeListener);
	}

	protected Listener escapeListener = event -> {
		if ((event.type == SWT.Traverse) && (event.detail == SWT.TRAVERSE_ESCAPE) && handleCancel())
		{
			event.doit = false;
			event.detail = SWT.NONE;
		}
	};

	protected boolean handleCancel()
	{
		Button cancelButton = getCancelButton();
		if (cancelButton == null || cancelButton.isDisposed() || getShell() != getDisplay().getActiveShell() || !cancelButton.getEnabled())
		{
			return false;
		}
		Event selectionEvent = new Event();
		selectionEvent.widget = cancelButton;
		cancelButton.notifyListeners(SWT.Selection, selectionEvent);
		return true;
	}

	protected void fireWidgetSelected(List<SelectionListener> listeners, SelectionEvent e)
	{
		for (SelectionListener listener : listeners)
		{
			listener.widgetSelected(e);
		}
	}

	protected void fireDefaultWidgetSelected(List<SelectionListener> listeners, SelectionEvent e)
	{
		for (SelectionListener listener : listeners)
		{
			listener.widgetDefaultSelected(e);
		}
	}

	public void addOKSelectionListener(SelectionListener listener)
	{
		if (!okSelectionListeners.contains(listener))
		{
			okSelectionListeners.add(listener);
		}
	}

	public void removeOKSelectionListener(SelectionListener listener)
	{
		if (okSelectionListeners.contains(listener))
		{
			okSelectionListeners.remove(listener);
		}
	}

	public void addCancelSelectionListener(SelectionListener listener)
	{
		if (!cancelSelectionListeners.contains(listener))
		{
			cancelSelectionListeners.add(listener);
		}
	}

	public void removeCancelSelectionListener(SelectionListener listener)
	{
		if (cancelSelectionListeners.contains(listener))
		{
			cancelSelectionListeners.remove(listener);
		}
	}

	protected List<SelectionListener> okSelectionListeners = new ArrayList<SelectionListener>();
	protected List<SelectionListener> cancelSelectionListeners = new ArrayList<SelectionListener>();

	@Override
	protected void checkSubclass()
	{
		// Disable the check that prevents subclassing of SWT components
	}

	protected static final String NEXT = "Next";
	protected static final String OK = "OK";
	protected static final String CANCEL = "Cancel";
}
