package com.candata.login.utils;

import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DefaultTrustManager implements X509TrustManager
{
	public static void configure()
	{
		if (isInitialized)
		{
			return;
		}
		try
		{
			isInitialized = true;
			HttpURLConnection.setFollowRedirects(false);

			SSLContext tlsContext = SSLContext.getInstance("TLS");
			tlsContext.init(new KeyManager[0], manager(), new SecureRandom());
			SSLContext.setDefault(tlsContext);

			SSLContext sslContext = SSLContext.getInstance("SSL");
			sslContext.init(null, manager(), new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
			// Create all-trusting host name verifier
			HostnameVerifier validHosts = (hostname, session) -> true;
			// All hosts will be valid
			HttpsURLConnection.setDefaultHostnameVerifier(validHosts);
		}
		catch (KeyManagementException | NoSuchAlgorithmException e)
		{
			throw new RuntimeException("error configuring SSL context", e);
		}
	}

	static TrustManager[] manager()
	{
		return new TrustManager[] { new DefaultTrustManager() };
	}

	@Override
	public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException
	{
	}

	@Override
	public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException
	{
	}

	@Override
	public X509Certificate[] getAcceptedIssuers()
	{
		return null;
	}

	private static boolean isInitialized = false;
}
