package com.candata.login.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import com.candata.login.utils.zoo.os.WindowsRegistry;

public class FolderUtils
{
	public static final String CANDATA_DIR_PROPERTY = "candata.base.directory";

	public static File getCandataDirectory()
	{
		if (System.getProperty(CANDATA_DIR_PROPERTY) == null)
		{
			return createOrGetCandataDirectory();
		}
		return new File(System.getProperty(CANDATA_DIR_PROPERTY));
	}

	protected static File createOrGetCandataDirectory()
	{
		File baseDir = null;
		boolean needsToHide = true;

		String parentDirectory = System.getProperty("user.home");
		if (Platform.isWindows())
		{
			if (parentDirectory.startsWith("\\"))
			{
				String location = "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
				String localAppDataDir = WindowsRegistry.readRegistry(location, "Local AppData");
				if (localAppDataDir != null)
				{
					needsToHide = false;
					parentDirectory = localAppDataDir;
				}
				else
				{
					// check installation dir
					String installDir = WindowsRegistry.readRegistry("HKCU\\Software\\Candata Inc\\Candata Customs", "Path");
					if (installDir != null)
					{
						installDir = installDir + "cache";
					}
					parentDirectory = canWriteToInstallDir(installDir) ? installDir : parentDirectory;
				}
			}
			baseDir = new File(parentDirectory, "candata");
			Platform.unhideWindowsDirectory(baseDir);
		}
		else
		{
			File oldBaseDir = new File(parentDirectory, ".candata");
			baseDir = new File(parentDirectory, "candata");
			if (oldBaseDir.exists() && !baseDir.exists())
			{
				try
				{
					Files.move(oldBaseDir.toPath(), baseDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
				}
				catch (IOException e)
				{
				}
			}
		}
		if (!baseDir.exists())
		{
			baseDir.mkdir();
		}
		System.setProperty(FolderUtils.CANDATA_DIR_PROPERTY, baseDir.getAbsolutePath());
		return baseDir;
	}

	protected static boolean canWriteToInstallDir(String installDir)
	{
		if (installDir == null || installDir.isEmpty())
		{
			return false;
		}
		File directory = new File(installDir);
		if (directory.exists() && directory.isDirectory() && directory.canWrite())
		{
			return true;
		}
		return false;
	}

}
