package com.candata.login.utils;

import java.awt.Toolkit;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Map;

public class Platform
{
	private static String OS_NAME;

	public enum OS
	{
		Windows, OSX, GTK;
	}

	protected static boolean isWindows;
	protected static boolean isGTK;
	protected static boolean isOSX;
	static
	{
		OS_NAME = System.getProperty("os.name");
		isWindows = OS_NAME.equals("win32") || OS_NAME.toLowerCase().contains("windows");
		isGTK = OS_NAME.equalsIgnoreCase("gtk") || OS_NAME.equalsIgnoreCase("linux");
		isOSX = OS_NAME.equalsIgnoreCase("carbon") || OS_NAME.equalsIgnoreCase("cocoa") || OS_NAME.contains("OS X");
	}

	public static OS getOS()
	{
		if (isWindows())
		{
			return OS.Windows;
		}
		if (isOSX())
		{
			return OS.OSX;
		}
		return OS.GTK;
	}

	public static boolean isWindows()
	{
		return isWindows;
	}

	public static boolean isOSX()
	{
		return isOSX;
	}

	public static boolean isGTK()
	{
		return isGTK;
	}

	public static void initializeToolkit()
	{
		if (isOSX)
		{
			Toolkit.getDefaultToolkit();
			System.setProperty("apple.laf.useScreenMenuBar", "true");
			System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Candata Global");
		}
	}

	public static void hideWindowsDirectory(File directory)
	{
		try
		{
			Process proc = Runtime.getRuntime().exec("attrib +h " + directory.getAbsolutePath());
			int exitVal = proc.waitFor();
		}
		catch (Throwable t)
		{
			// quiet for now, it didn't hide, no big deal
		}
	}

	public static void unhideWindowsDirectory(File directory)
	{
		try
		{
			Process proc = Runtime.getRuntime().exec("attrib -h " + directory.getAbsolutePath());
			int exitVal = proc.waitFor();
		}
		catch (Throwable t)
		{
			// quiet for now, it didn't hide, no big deal
		}
	}

	public static boolean needsOSXExecutor(Map<String, String> environment)
	{

		if (!isOSX)
		{
			return false;
		}
		String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
		String onFirstThread = environment.get("JAVA_STARTED_ON_FIRST_THREAD_" + pid);
		return !"1".equals(onFirstThread);
	}
}
