package com.candata.login.oauth;

import com.candata.login.oauth.beans.Authentication;
import com.candata.login.oauth.beans.Authentication.SupportAuthentications;
import com.candata.login.oauth.beans.FlowProperties;
import com.candata.login.oauth.oauth2.SupportAuthenticator;
import com.candata.login.oauth.oauth2.UserAuthenticator;
import com.candata.login.oauth.support.oauth2.beans.OAuthSupportProperties.Flows;

import io.reactivex.rxjava3.core.Maybe;

public class Authenticator
{
	static Authentication authentication;
	static SupportAuthentications authentications = new SupportAuthentications();
	static FlowProperties properties;
	static Flows flows;

	public static Maybe<SupportAuthentications> authenticate(Flows flows)
	{
		Authenticator.flows = flows;
		return SupportAuthenticator.authenticate(flows)
				.doOnSuccess(auths -> Authenticator.authentications = auths);
	}

	public static Maybe<Authentication> authenticate(FlowProperties properties)
	{
		Authenticator.properties = properties;
		if (properties.isSupport())
		{
			return SupportAuthenticator.authenticate(properties)
					.doOnSuccess(auth -> Authenticator.authentication = auth);
		}
		return UserAuthenticator.authenticate(properties)
				.doOnSuccess(auth -> Authenticator.authentication = auth);
	}

	public static Maybe<Authentication> refresh()
	{
		return authenticate(properties);
	}

	public static Maybe<Authentication> get()
	{
		return Maybe.fromCallable(() -> authentication)
				.doOnComplete(() -> System.out.println("no authentication"))
				.switchIfEmpty(Maybe.fromCallable(authentications::getAuthentication));
	}
}
