package com.candata.login.oauth;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import com.candata.login.oauth.beans.Authentication;

public class TokenRefreshServiceImpl
{
	public static ServiceRegistration<Function> register(BundleContext ctx)
	{
		return new TokenRefreshServiceImpl().doRegister(ctx);
	}

	protected ServiceRegistration<Function> doRegister(BundleContext ctx)
	{
		Dictionary<String, String> properties = new Hashtable<>();
		properties.put("name", "TokenRefreshService");
		return ctx.registerService(Function.class, this::handle, properties);
	}

	protected Map<String, String> handle(Object request)
	{
		if (!(request instanceof String))
		{
			return null;
		}
		if (REFRESH.equalsIgnoreCase((String) request))
		{
			return refresh();
		}
		return buildProperties(Authenticator.get().blockingGet());
	}

	protected Map<String, String> refresh()
	{
		return Authenticator.refresh()
				.map(this::buildProperties)
				.blockingGet();
	}

	protected Map<String, String> buildProperties(Authentication auth)
	{
		System.out.println("building properties");
		Map<String, String> tokenProperties = new HashMap<>();
		tokenProperties.put("idToken", auth.getIdToken());
		tokenProperties.put("iamProxyToken", auth.getIAMProxyToken());
		tokenProperties.put("idTokenPayload", auth.getIdTokenPayload().toString());
		tokenProperties.put("accessToken", auth.getAccessToken());
		tokenProperties.put("refreshToken", auth.getRefreshToken());
		tokenProperties.put("expiresIn", auth.getExpiresInSeconds().toString());
		tokenProperties.put("email", auth.getEmail());
		tokenProperties.put("companyName", auth.getCompany().getName());
		tokenProperties.put("companyRealm", auth.getCompany().getRealm());
		tokenProperties.put("namespace", auth.getNamespace());
		tokenProperties.put("environment", auth.getCompany().getEnvironment().toString());
		tokenProperties.put("rxId", auth.getRXId());
		return tokenProperties;
	}

	static final String REFRESH = "refresh";
	static final String GET = "get";
}
