package com.candata.login.oauth.beans;

import java.util.Base64;

import org.json.JSONObject;

import com.candata.login.oauth.oauth2.Constants;
import com.candata.login.oauth.oauth2.beans.OAuthProperties;
import com.candata.login.oauth.users.Company;
import com.candata.login.oauth.zoo.support.oauth2.beans.IdCredential;

public class Authentication
{
	public static class SupportAuthentications
	{
		public Authentication getTest()
		{
			return testAuth;
		}

		public SupportAuthentications setTest(Authentication testAuth)
		{
			this.testAuth = testAuth;
			return this;
		}

		public Authentication getAuthentication()
		{
			return testAuth.getCompany().getEnvironment() == Environment.Test ? testAuth : productionAuth;
		}

		public Authentication getProduction()
		{
			return productionAuth;
		}

		public SupportAuthentications setProduction(Authentication productionAuth)
		{
			this.productionAuth = productionAuth;
			return this;
		}

		public void setCompany(Company company)
		{
			testAuth.setCompany(company);
			productionAuth.setCompany(company);
		}

		public void setRXId(String rxId)
		{
			testAuth.setRXId(rxId);
			productionAuth.setRXId(rxId);
		}

		public void setImpersonatedEmail(String email)
		{
			testAuth.setImpersonatedEmail(email);
			productionAuth.setImpersonatedEmail(email);
		}

		public boolean isValid()
		{
			return isValid(testAuth) && isValid(productionAuth);
		}

		protected boolean isValid(Authentication auth)
		{
			return auth != null && auth.getAccessToken() != null && auth.getAccessToken().length() > 20;
		}

		@Override
		public String toString()
		{
			return "Test Auth\n" + (testAuth == null ? "<null>" : testAuth) + "\n\nProduction Auth\n"
					+ (productionAuth == null ? "<null>" : productionAuth);
		}

		Authentication testAuth;
		Authentication productionAuth;
	}

	public Authentication(IdCredential credential)
	{
		this(credential.getIdToken(), credential.getAccessToken(), credential.getRefreshToken(), credential.getExpiresInSeconds());
	}

	public Authentication(String idToken, String accessToken, String refreshToken, Long expiresInSeconds)
	{
		this.idToken = idToken;
		this.accessToken = accessToken;
		this.refreshToken = refreshToken;
		this.expiresInSeconds = expiresInSeconds;
	}

	public boolean isSupport()
	{
		return getEmail().endsWith(Constants.SUPPORT_EMAIL_DOMAIN);
	}

	public boolean isAuthenticated()
	{
		return (accessToken != null) && (accessToken.length() > 10);
	}

	public Long getExpiresInSeconds()
	{
		return expiresInSeconds;
	}

	public Company getCompany()
	{
		return company;
	}

	public void setCompany(Company company)
	{
		this.company = company;
	}

	public String getAccessToken()
	{
		return accessToken;
	}

	public String getRefreshToken()
	{
		return refreshToken;
	}

	public String getIdToken()
	{
		return idToken;
	}

	public String getIAMProxyToken()
	{
		if (isSupport())
		{
			return idToken;
		}
		return iamProxyToken;
	}

	public Authentication setIAMProxyToken(String token)
	{
		this.iamProxyToken = token;
		return this;
	}

	public String getRXId()
	{
		return rxId;
	}

	public Authentication setRXId(String rxId)
	{
		this.rxId = rxId;
		return this;
	}

	public String getImpersonatedEmail()
	{
		return impersonatedEmail;
	}

	public Authentication setImpersonatedEmail(String email)
	{
		this.impersonatedEmail = email;
		return this;
	}

	public String getNamespace()
	{
		if (isSupport())
		{
			if (company == null)
			{
				throw new RuntimeException("missing company");
			}
			return company.getNamespace();
		}
		return getIdTokenPayload()
				.optString(OAuthProperties.NAMESPACE_PAYLOAD_KEY);
	}

	public String getEmail()
	{
		return getIdTokenPayload()
				.optString("email");
	}

	public JSONObject getIdTokenPayload()
	{
		if (payload == null)
		{
			String[] chunks = idToken.split("\\.");
			Base64.Decoder decoder = Base64.getUrlDecoder();
			String header = new String(decoder.decode(chunks[0]));
			String decodedPayload = new String(decoder.decode(chunks[1]));
			payload = new JSONObject(decodedPayload);
		}
		return payload;
	}

	@Override
	public String toString()
	{
		return "Authentication\n\texpiresInSeconds: " + expiresInSeconds + "\n\taccessToken: " + accessToken + "\n\trefreshToken: " + refreshToken
				+ "\n\tidToken: " + idToken + "\n\tiamProxyToken: " + iamProxyToken + "\n\tpayload: " + payload;
	}

	Company company;
	Long expiresInSeconds;
	String idToken;
	String accessToken;
	String refreshToken;
	String iamProxyToken;
	String rxId;
	String impersonatedEmail;
	JSONObject payload;
}
