package com.candata.login.oauth.beans;

import static com.candata.login.oauth.oauth2.Constants.DEVEL_DOMAIN_INSERT;
import static com.candata.login.oauth.oauth2.beans.OAuthProperties.AUTH_SERVER_DEFAULT;
import static com.candata.login.oauth.oauth2.beans.OAuthProperties.AUTH_SERVER_PROPERTY;

import com.candata.login.utils.StringUtils;

public enum Environment
{
	Production, Test;

	public static Environment get(String value)
	{
		switch (value.toLowerCase())
		{
		case "production":
			return Production;
		default:
			return Test;
		}
	}

	public static boolean is(Environment test)
	{
		return get() == test;
	}

	public static Environment get()
	{
		return System.getProperty(AUTH_SERVER_PROPERTY, AUTH_SERVER_DEFAULT).equals(AUTH_SERVER_DEFAULT) ? Environment.Production : Environment.Test;
	}

	public String getProjectId()
	{
		return this == Production ? PROJECT_ID_PRODUCTION : PROJECT_ID_TEST;
	}

	public String getProjectName()
	{
		return this == Production ? PROJECT_NAME_PRODUCTION : PROJECT_NAME_TEST;
	}

	public String getURLInsert()
	{
		return this == Production ? StringUtils.EMPTY : DEVEL_DOMAIN_INSERT;
	}

	protected static final String PROJECT_ID_TEST = "578066310216";
	protected static final String PROJECT_NAME_TEST = "candata-test";
	protected static final String PROJECT_ID_PRODUCTION = "1094879361581";
	protected static final String PROJECT_NAME_PRODUCTION = "candata-prod";
}
