package com.candata.login.oauth.support.oauth2.beans;

import static com.candata.login.utils.URLUtils.url;

import java.net.MalformedURLException;
import java.net.URL;

import com.candata.login.oauth.beans.Environment;
import com.candata.login.oauth.beans.FlowProperties;
import com.candata.login.oauth.oauth2.beans.OAuthProperties;
import com.candata.login.oauth.users.Company;

public interface OAuthSupportProperties
{
	public static final URL TOKEN_URL = url("https://oauth2.googleapis.com/token");
	public static final URL AUTH_URL = url("https://accounts.google.com/o/oauth2/v2/auth");
	public static final String DESKTOP_CLIENT_ID = "1094879361581-nov580isqs90dkg91bd4fhd395ep7rok.apps.googleusercontent.com";
	public static final String TEST_DESKTOP_CLIENT_ID = "578066310216-que0j1cd8rc5murmpfn153f55c4u3vuc.apps.googleusercontent.com";
	public static final String DESKTOP_SECRET = "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";
	public static final String TEST_DESKTOP_SECRET = "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";
	public static final String NAMESPACES_URL = "https://app.candata.com/rx/support/login/namespaces";
	public static final String TEST_NAMESPACES_URL = "https://app.devel.candata.com/rx/support/login/namespaces";
	public static final String ALL_USERS_URL = "https://app.candata.com/rx/support/login/users";
	public static final String TEST_ALL_USERS_URL = "https://app.devel.candata.com/rx/support/login/users";
	public static final Company SUPPORT_COMPANY = new Company("support");

	public record Flows(FlowProperties testProperties, FlowProperties productionProperties)
	{
	}

	public static FlowProperties build(String email, Environment environment)
	{
		if (environment == Environment.Test)
		{
			return new FlowProperties(OAuthSupportProperties.TOKEN_URL, OAuthSupportProperties.getAuthURL(email),
					OAuthSupportProperties.TEST_DESKTOP_CLIENT_ID, OAuthSupportProperties.TEST_DESKTOP_SECRET,
					OAuthProperties.TEST_IAM_PROXY_AUDIENCE,
					email, SUPPORT_COMPANY, true);
		}
		return new FlowProperties(OAuthSupportProperties.TOKEN_URL, OAuthSupportProperties.getAuthURL(email),
				OAuthSupportProperties.DESKTOP_CLIENT_ID, OAuthSupportProperties.DESKTOP_SECRET, OAuthProperties.IAM_PROXY_AUDIENCE,
				email, SUPPORT_COMPANY, true);
	}

	public static Flows build(String email)
	{
		return new Flows(new FlowProperties(OAuthSupportProperties.TOKEN_URL, OAuthSupportProperties.getAuthURL(email),
				OAuthSupportProperties.TEST_DESKTOP_CLIENT_ID, OAuthSupportProperties.TEST_DESKTOP_SECRET,
				OAuthProperties.TEST_IAM_PROXY_AUDIENCE,
				email, SUPPORT_COMPANY, true),
				new FlowProperties(OAuthSupportProperties.TOKEN_URL, OAuthSupportProperties.getAuthURL(email),
						OAuthSupportProperties.DESKTOP_CLIENT_ID, OAuthSupportProperties.DESKTOP_SECRET, OAuthProperties.IAM_PROXY_AUDIENCE,
						email, SUPPORT_COMPANY, true));
	}

	public static URL getAuthURL(String email)
	{
		try
		{
			return new URL(AUTH_URL + "?login_hint=" + email);
		}
		catch (MalformedURLException e)
		{
			throw new RuntimeException(e);
		}
	}

	public static String getAllUsersURL()
	{
		if (OAuthProperties.isTestAuthServer())
		{
			return TEST_ALL_USERS_URL;
		}
		return ALL_USERS_URL;
	}

	public static String getNamespacesURL(Environment environment)
	{
		if (environment == Environment.Test)
		{
			return TEST_NAMESPACES_URL;
		}
		return NAMESPACES_URL;
	}
}
