package com.candata.login.oauth.users;

import java.util.ArrayList;
import java.util.List;

import com.candata.login.oauth.beans.Environment;
import com.candata.login.oauth.oauth2.Constants;

public class User
{
	public User(String email)
	{
		this.email = email;
	}

	public String getEmail()
	{
		return email;
	}

	public String getFirstName()
	{
		return firstName;
	}

	public void setFirstName(String firstName)
	{
		this.firstName = firstName;
	}

	public String getLastName()
	{
		return lastName;
	}

	public void setLastName(String lastName)
	{
		this.lastName = lastName;
	}

	public String getCompany()
	{
		return company;
	}

	public void setCompany(String company)
	{
		this.company = company;
	}

	public void add(Company company)
	{
		companies.add(company);
	}

	public String getNamespace()
	{
		return namespace;
	}

	public void setNamespace(String namespace)
	{
		this.namespace = namespace;
	}

	public Application getApplication()
	{
		return application;
	}

	public void setApplication(Application application)
	{
		this.application = application;
	}

	public Environment getEnvironment()
	{
		return environment;
	}

	public void setEnvironment(Environment environment)
	{
		this.environment = environment;
	}

	public List<Company> getCompanies()
	{
		return companies;
	}

	public boolean isEmpty()
	{
		return "".equals(getFirstName()) && "".equals(getLastName()) && "".equals(getEmail());
	}

	public boolean isSupport()
	{
		return getEmail() != null && getEmail().endsWith(Constants.SUPPORT_EMAIL_DOMAIN);
	}

	static String json = """
				{"tenants":[
				{"tenantName":"Mckay-test","isVerified":false,"created":1694548018211,"lastSignIn":0,"tenantId":"Mckay-test-hsh30","namespace":"test","company":"mckay","userId":"WclHQYYIIyXYsfNO1TnqKTKXeqp1"},
				{"tenantName":"candatatest-test","isVerified":false,"created":1694551189797,"lastSignIn":1694555588322,"tenantId":"candatatest-test-hzxo3","namespace":"test","company":"candatatest","userId":"ED80vTmpTTYJXupY71c1HiRBmkt1"}]
			,
			"environment":"test","email":"jamiedougal@gmail.com"}
			""";
	String email;
	String firstName = "";
	String lastName = "";
	String company = "";
	String namespace = "";
	Application application = Application.CBSA;
	Environment environment = Environment.Test;
	List<Company> companies = new ArrayList<>();
}
