package com.candata.login.oauth.users.oauth2;

import static com.candata.login.utils.StringUtils.EMPTY;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import com.candata.login.oauth.beans.Authentication;
import com.candata.login.oauth.oauth2.beans.ValidationResponse;

import io.reactivex.rxjava3.core.Maybe;

public class ValidateToken
{
	public static Maybe<ValidationResponse> validate(Authentication authentication)
	{
		return Maybe.fromCallable(() -> getResponse(authentication));
	}

	protected static ValidationResponse getResponse(Authentication authentication)
	{
		decode(authentication.getIAMProxyToken());
		return new ValidationResponse(authentication, 200, EMPTY);
	}

	public static void decode(String token)
	{
		String[] chunks = token.split("\\.");
		Base64.Decoder decoder = Base64.getUrlDecoder();

		String header = new String(decoder.decode(chunks[0]));
		String payload = new String(decoder.decode(chunks[1]));
	}

	public static String getPayload(String token)
	{
		String[] chunks = token.split("\\.");
		Base64.Decoder decoder = Base64.getUrlDecoder();
		return new String(decoder.decode(chunks[1]));
	}

	protected static String buildMessage(InputStream inputStream)
	{
		StringBuilder message = new StringBuilder();
		try (Reader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)))
		{
			int c = 0;
			while ((c = reader.read()) != -1)
			{
				message.append((char) c);
			}
		}
		catch (IOException e)
		{

		}
		return message.toString();
	}
}
