package com.candata.login.oauth.zoo.oauth2;

import java.io.IOException;
import java.util.Map;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Data;

public class AuthenticationParameters extends ClientParametersAuthentication
{

	public AuthenticationParameters(String clientId, String clientSecret)
	{
		super(clientId, clientSecret);
	}

	@Override
	public void intercept(HttpRequest request) throws IOException
	{
		super.intercept(request);
		if (audience != null)
		{
			Map<String, Object> data = Data.mapOf(UrlEncodedContent.getContent(request).getData());
			data.put("audience", audience);
		}
	}

	public String getAudience()
	{
		return audience;
	}

	public AuthenticationParameters setAudience(String audience)
	{
		this.audience = audience;
		return this;
	}

	private String audience;
}
