package com.candata.login.oauth.zoo.oauth2.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AuthenticateShell extends Shell
{
	/**
	 * Create the shell.
	 * @param display
	 */
	public AuthenticateShell(Display display)
	{
		super(display, SWT.SHELL_TRIM);
		setLayout(new GridLayout(1, false));

		createContents();
		addListeners();
	}

	public AuthenticateShell(Shell parentShell)
	{
		super(parentShell, SWT.SHELL_TRIM);
		setLayout(new GridLayout(1, false));

		createContents();
		addListeners();
	}

	public AuthenticateShell setCloseTriggerText(String closeTriggerText)
	{
		this.closeTriggerText = closeTriggerText.toLowerCase();
		return this;
	}

	public AuthenticateShell setOnCancel(Runnable onCancel)
	{
		this.onCancel = onCancel;
		return this;
	}

	protected void cancel()
	{
		if (onCancel != null)
		{
			onCancel.run();
		}
		dispose();
	}

	public void authenticate(String url)
	{
		open();
		layout();
		authBrowser.setUrl(url);
		authBrowser.setFocus();
		Display display = getDisplay();
		while (!isDisposed())
		{
			if (!display.readAndDispatch())
			{
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the shell.
	 */
	protected void createContents()
	{
		setText("Authenticate");
		setSize(860, 890);
		authBrowser = new Browser(this, EDGE);
		authBrowser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		closeButton = new Button(this, SWT.NONE);
		GridData gd_closeButton = new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1);
		gd_closeButton.minimumWidth = 86;
		gd_closeButton.widthHint = 86;
		closeButton.setLayoutData(gd_closeButton);
		closeButton.setText("Close");
		setDefaultButton(closeButton);
		centre();
	}

	protected void centre()
	{
		Rectangle screenBounds = getDisplay().getBounds();
		Rectangle shellBounds = getBounds();

		int x = screenBounds.x + ((screenBounds.width - shellBounds.width) / 2);
		int y = screenBounds.y + ((screenBounds.height - shellBounds.height) / 2);

		setLocation(x, y);
	}

	protected void addListeners()
	{
		closeButton.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent event)
			{
				cancel();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent event)
			{
				widgetSelected(event);
			}
		});
		addListener(SWT.Traverse, event -> {
			switch (event.detail)
			{
			case SWT.TRAVERSE_ESCAPE:
				event.detail = SWT.TRAVERSE_NONE;
				event.doit = false;
				cancel();
				break;
			}
		});
		authBrowser.addProgressListener(new ProgressAdapter() {
			@Override
			public void completed(ProgressEvent event)
			{
				if ((closeTriggerText != null) && !"".equals(closeTriggerText))
				{
					if (authBrowser.getText().toLowerCase().contains(closeTriggerText))
					{
						dispose();
						return;
					}
					authBrowser.execute("document.getElementById(\"username\").focus();");
					String focusMethod = """
							if ( document.body.contains("password")){
								document.getElementById("username").disabled = true;
								authBrowser.execute("document.getElementById("password").focus();
							}
							""";
					authBrowser.execute(focusMethod);
				}
			}
		});
	}

	@Override
	protected void checkSubclass()
	{
		// Disable the check that prevents subclassing of SWT components
	}

	protected Browser authBrowser;
	protected Button closeButton;
	protected String closeTriggerText;
	Runnable onCancel;
	public static final int EDGE = 1 << 18;
}
