package com.candata.login.oauth.zoo.security.test;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

import org.eclipse.swt.widgets.Display;

import com.candata.login.oauth.Authenticator;
import com.candata.login.oauth.oauth2.beans.OAuthProperties;
import com.candata.login.oauth.users.Company;

import io.reactivex.rxjava3.schedulers.Schedulers;

public class AuthenticatorTest
{
	public static void main(String[] args)
	{
		Display display = Display.getDefault();
		AtomicBoolean done = new AtomicBoolean();
		AtomicReference<String> accessToken = new AtomicReference<>();

		Company company = new Company("candatatest");
		company.setNamespace("test");
		//		String secret = "VCYApQPIeltvSZ1LpWygJaEUn7kmDg4U"; //auth.devel
		String secret = "gfHxKt6Qa27uXudQsGGjkH6rKhZTZRLe";//auth

		company.setClientSecret(secret);
		String email = "jamiedougal@gmail.com";
		//		String company = "mckay";
		//		String secret = "CR106dUjVFyUOFuVsKeoi52ccxgiuRMa";

		Authenticator.authenticate(OAuthProperties.build(email, company, true))
				.subscribeOn(Schedulers.computation())
				.doOnSuccess(auth -> accessToken.set(auth.getIAMProxyToken()))
				.doOnSuccess(auth -> System.out.println(auth))
				.doOnComplete(() -> System.out.println("Cancelled"))
				.doFinally(() -> done.set(true))
				.subscribe();
		while (true)
		{
			if (done.get() || display.isDisposed())
			{
				break;
			}
			if (!display.readAndDispatch())
			{
				display.sleep();
			}
			if (done.get())
			{
				break;
			}
		}
	}
}
