package com.candata.login.oauth.zoo.security.test;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.swt.widgets.Display;

import com.candata.login.oauth.oauth2.SupportAuthenticator;
import com.candata.login.oauth.support.oauth2.beans.OAuthSupportProperties;

import io.reactivex.rxjava3.schedulers.Schedulers;

public class SupportAuthenticatorTest
{
	public static void main(String[] args)
	{
		Display display = Display.getDefault();
		AtomicBoolean done = new AtomicBoolean();

		SupportAuthenticator.authenticate(OAuthSupportProperties.build("jamie.dougal@candata.com"))
				.subscribeOn(Schedulers.computation())
				.doOnComplete(() -> System.out.println("Cancelled"))
				.doFinally(() -> done.set(true))
				.subscribe();
		while (true)
		{
			if (done.get() || display.isDisposed())
			{
				break;
			}
			if (!display.readAndDispatch())
			{
				display.sleep();
			}
			if (done.get())
			{
				break;
			}
		}
	}
}
