package com.candata.login.oauth.zoo.support.oauth2;

import java.io.IOException;

import com.candata.login.oauth.zoo.support.oauth2.beans.IdCredential;
import com.candata.login.oauth.zoo.support.oauth2.store.IdStore;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.http.GenericUrl;

public class IdCodeInstalledApp extends AuthorizationCodeInstalledApp
{
	AuthorizationCodeFlow flow;
	VerificationCodeReceiver receiver;

	public IdCodeInstalledApp(AuthorizationCodeFlow flow, VerificationCodeReceiver receiver, Browser browser)
	{
		super(flow, receiver, browser);
		this.flow = flow;
		this.receiver = receiver;
	}

	@Override
	@Deprecated
	public Credential authorize(String userId) throws IOException
	{
		//		return authorize();
		throw new RuntimeException();
	}

	public IdCredential authorize()
	{
		IdStore store = new IdStore(flow.getCredentialDataStore());
		IdCredential credential = checkStore(store);
		if (credential != null)
		{
			return credential;
		}
		try
		{
			// open in browser
			String redirectUri = receiver.getRedirectUri();
			AuthorizationCodeRequestUrl authorizationUrl = flow.newAuthorizationUrl().setRedirectUri(redirectUri);
			onAuthorization(authorizationUrl);
			// receive authorization code and exchange it for an access token
			String code = receiver.waitForCode();
			if (code == null)
			{
				return null;
			}
			TokenResponse response = flow.newTokenRequest(code)
					.setResponseClass(IdTokenResponse.class)
					.setRedirectUri(redirectUri)
					.execute();
			// store credential and return it
			flow.createAndStoreCredential(response, "");
			return store.save(IdCredential.create(response));
		}
		catch (IOException e)
		{
			throw new RuntimeException("error authorizing", e);
		}
		finally
		{
			try
			{
				receiver.stop();
			}
			catch (IOException e)
			{
				throw new RuntimeException("error stopping callback receiver", e);
			}
		}
	}

	private IdCredential checkStore(IdStore store)
	{
		try
		{
			IdCredential credential = store.load();
			if (credential != null)
			{
				if (isValid(credential.getRefreshToken()))
				{
					RefreshTokenRequest request = new RefreshTokenRequest(flow.getTransport(), flow.getJsonFactory(),
							new GenericUrl(flow.getTokenServerEncodedUrl()), credential.getRefreshToken())
									.setClientAuthentication(flow.getClientAuthentication())
									.setResponseClass(IdTokenResponse.class);

					TokenResponse response = request.execute();
					return store.save(IdCredential.create(response)
							.setRefreshToken(credential.getRefreshToken()));
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return null;
	}

	private static boolean isValid(String value)
	{
		return (value != null) && (value.length() > 10);
	}
}
