package com.candata.login.oauth.zoo.support.oauth2.google;

import static java.lang.String.format;

import java.net.URI;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpRequest.Builder;

import org.json.JSONObject;

import com.candata.login.utils.HttpUtils;
import com.candata.login.utils.HttpUtils.ContentType;

import io.reactivex.rxjava3.core.Maybe;

public class TokenExchange
{
	public static Maybe<JSONObject> exchangeForTemp(String audience, String idToken)
	{
		return HttpUtils.buildPost(TEMP_TOKEN_EXCHANGE_URI, ContentType.JSON, buildPayload(audience, idToken))
				.map(Builder::build)
				.flatMapMaybe(HttpUtils::doRequest)
				.map(JSONObject::new);
	}

	public static Maybe<JSONObject> exchangeForAccess(String serviceAccount, String audience, String token)
	{
		return exchangeForAccess(URI.create(format("https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateIdToken",
				serviceAccount)), audience, token);
	}

	public static Maybe<JSONObject> exchangeForAccess(URI uri, String audience, String token)
	{
		return HttpUtils.buildPost(uri, ContentType.JSON, buildAccessPayload(audience), token)
				.map(Builder::build)
				.flatMapMaybe(HttpUtils::doRequest)
				.map(JSONObject::new);
	}

	protected static BodyPublisher buildPayload(String audience, String idToken)
	{
		JSONObject payload = new JSONObject();
		payload.put("grantType", "urn:ietf:params:oauth:grant-type:token-exchange");
		payload.put("audience", audience.replace("https:", ""));
		payload.put("scope", "https://www.googleapis.com/auth/cloud-platform");
		payload.put("requestedTokenType", "urn:ietf:params:oauth:token-type:access_token");
		payload.put("subject_token", idToken);
		payload.put("subjectTokenType", "urn:ietf:params:oauth:token-type:id_token");
		return BodyPublishers.ofString(payload.toString());
	}

	protected static BodyPublisher buildAccessPayload(String audience)
	{
		JSONObject payload = new JSONObject();
		payload.put("audience", audience);
		payload.put("includeEmail", true);
		return BodyPublishers.ofString(payload.toString());
	}

	protected static final URI TEMP_TOKEN_EXCHANGE_URI = URI.create("https://sts.googleapis.com/v1/token");
}
