package com.candata.login.oauth.zoo.support.oauth2.store;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;

import com.candata.login.oauth.beans.FlowProperties;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;

public class TokenDataStoreFactory extends AbstractDataStoreFactory
{
	private File dataDirectory;
	private AbstractDataStoreFactory factory;
	private boolean rememberMe;

	public TokenDataStoreFactory(FlowProperties properties, File dataDirectory)
	{
		this.rememberMe = properties.rememberMe();
		this.dataDirectory = dataDirectory;
	}

	@Override
	protected <V extends Serializable> DataStore<V> createDataStore(String key) throws IOException
	{
		if (!rememberMe && dataDirectory.exists())
		{
			Path authDirectory = dataDirectory.getParentFile().getParentFile().toPath();
			Files
					.walk(authDirectory)
					.sorted(Comparator.reverseOrder())
					.forEach(this::delete);
			dataDirectory.delete();
		}
		factory = rememberMe ? new FileDataStoreFactory(dataDirectory) : new MemoryDataStoreFactory();
		return factory.getDataStore(key);
	}

	private void delete(Path path)
	{
		try
		{
			Files.delete(path);
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}
}
