/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010,\u001a\u00020\u000eH\u0016J\u001c\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020.00H\u0016J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0004H\u0002J\u0010\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0000H\u0002J\u0012\u00105\u001a\u00020\f2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\fH\u0002J\u0018\u00109\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\fH\u0002J\b\u0010;\u001a\u00020<H\u0016J8\u0010=\u001a\u00020.*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0>2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0002R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001fR\u0014\u0010 \u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001a\u00a8\u0006B"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "", "", "", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "(Ljava/util/Map;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "currentInfo", "getCurrentInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "getEndSlot", "()I", "firstInfo", "getFirstInfo", "getInfoList", "()Ljava/util/List;", "()Z", "lastInfo", "getLastInfo", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "getSelectableIdToInfoListIndex", "()Ljava/util/Map;", "size", "getSize", "startInfo", "getStartInfo", "getStartSlot", "createSubSelections", "selection", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "getInfoListIndexBySelectableId", "id", "shouldAnyInfoRecomputeSelection", "other", "shouldRecomputeSelection", "slotToIndex", "slot", "isMinimumSlot", "startOrEndSlotToIndex", "isStartSlot", "toString", "", "createAndPutSubSelection", "", "info", "minOffset", "maxOffset", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,714:1\n1#2:715\n69#3,6:716\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n263#1:716,6\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    @NotNull
    private final Map<Long, Integer> selectableIdToInfoListIndex;
    @NotNull
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    @Nullable
    private final Selection previousSelection;

    public MultiSelectionLayout(@NotNull Map<Long, Integer> selectableIdToInfoListIndex, @NotNull List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, @Nullable Selection previousSelection) {
        Intrinsics.checkNotNullParameter(selectableIdToInfoListIndex, (String)"selectableIdToInfoListIndex");
        Intrinsics.checkNotNullParameter(infoList, (String)"infoList");
        this.selectableIdToInfoListIndex = selectableIdToInfoListIndex;
        this.infoList = infoList;
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        if (!(this.infoList.size() > 1)) {
            boolean bl = false;
            String string = "MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + '.';
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Map<Long, Integer> getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    @NotNull
    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    @Nullable
    public Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public int getSize() {
        return this.infoList.size();
    }

    @Override
    @NotNull
    public CrossStatus getCrossStatus() {
        return this.getStartSlot() < this.getEndSlot() ? CrossStatus.NOT_CROSSED : (this.getStartSlot() > this.getEndSlot() ? CrossStatus.CROSSED : this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus());
    }

    @Override
    @NotNull
    public SelectableInfo getStartInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getStartSlot(), true));
    }

    @Override
    @NotNull
    public SelectableInfo getEndInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getEndSlot(), false));
    }

    @Override
    @NotNull
    public SelectableInfo getCurrentInfo() {
        return this.isStartHandle() ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getFirstInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getEndInfo() : this.getStartInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getLastInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    public void forEachMiddleInfo(@NotNull Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int minIndex = this.getInfoListIndexBySelectableId(this.getFirstInfo().getSelectableId());
        int maxIndex = this.getInfoListIndexBySelectableId(this.getLastInfo().getSelectableId());
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    @Override
    public boolean shouldRecomputeSelection(@Nullable SelectionLayout other) {
        return this.getPreviousSelection() == null || other == null || !(other instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)other).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)other).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)other).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)other);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout other) {
        if (this.getSize() != other.getSize()) {
            return true;
        }
        int n = this.infoList.size();
        for (int i = 0; i < n; ++i) {
            SelectableInfo otherInfo;
            SelectableInfo thisInfo = this.infoList.get(i);
            if (!thisInfo.shouldRecomputeSelection(otherInfo = other.infoList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<Long, Selection> createSubSelections(@NotNull Selection selection) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            if (!(selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset())) {
                boolean $i$a$-check-MultiSelectionLayout$createSubSelections$22 = false;
                String $i$a$-check-MultiSelectionLayout$createSubSelections$22 = "unexpectedly miss-crossed selection: " + selection;
                throw new IllegalStateException($i$a$-check-MultiSelectionLayout$createSubSelections$22.toString());
            }
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)selection.getStart().getSelectableId(), (Object)selection));
        } else {
            Map map2;
            Map $this$createSubSelections_u24lambda_u244 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            Selection $this$createSubSelections_u24lambda_u244_u24lambda_u242 = selection;
            boolean bl2 = false;
            Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u244_u24lambda_u242.getStart();
            this.createAndPutSubSelection($this$createSubSelections_u24lambda_u244, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
            this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)new Function1<SelectableInfo, Unit>(this, (Map<Long, Selection>)$this$createSubSelections_u24lambda_u244, selection){
                final /* synthetic */ MultiSelectionLayout this$0;
                final /* synthetic */ Map<Long, Selection> $this_buildMap;
                final /* synthetic */ Selection $selection;
                {
                    this.this$0 = $receiver;
                    this.$this_buildMap = $receiver2;
                    this.$selection = $selection;
                    super(1);
                }

                public final void invoke(@NotNull SelectableInfo info) {
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    MultiSelectionLayout.access$createAndPutSubSelection(this.this$0, this.$this_buildMap, this.$selection, info, 0, info.getTextLength());
                }
            }));
            Selection $this$createSubSelections_u24lambda_u244_u24lambda_u243 = selection;
            boolean bl3 = false;
            Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u243.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u243.getStart() : $this$createSubSelections_u24lambda_u244_u24lambda_u243.getEnd();
            this.createAndPutSubSelection($this$createSubSelections_u24lambda_u244, selection, this.getLastInfo(), 0, maxAnchor.getOffset());
            map = MapsKt.build((Map)map2);
        }
        return map;
    }

    private final void createAndPutSubSelection(Map<Long, Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        if (!(minOffset <= maxOffset)) {
            boolean bl = false;
            String string = "minOffset should be less than or equal to maxOffset: " + subSelection;
            throw new IllegalStateException(string.toString());
        }
        $this$createAndPutSubSelection.put(info.getSelectableId(), subSelection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$fastForEachIndexed$iv;
        void $this$toString_u24lambda_u247;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder().append("MultiSelectionLayout(isStartHandle=").append(this.isStartHandle()).append(", startPosition=").append((float)(this.getStartSlot() + 1) / (float)2).append(", endPosition=").append((float)(this.getEndSlot() + 1) / (float)2).append(", crossed=").append((Object)this.getCrossStatus()).append(", infos=");
        boolean bl = false;
        $this$toString_u24lambda_u247.append("[\n\t");
        boolean first = false;
        first = true;
        List<SelectableInfo> list = this.infoList;
        boolean $i$f$fastForEachIndexed = false;
        int n = $this$fastForEachIndexed$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            SelectableInfo selectableInfo = (SelectableInfo)item$iv;
            int index2 = index$iv;
            boolean bl2 = false;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u247.append(",\n\t");
            }
            $this$toString_u24lambda_u247.append(index2 + 1 + " -> " + info);
        }
        $this$toString_u24lambda_u247.append("\n]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder3.append(string).append(')').toString();
    }

    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                if (!isStartSlot) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex(slot, bl);
    }

    private final int slotToIndex(int slot, boolean isMinimumSlot) {
        int slotAdjustment = isMinimumSlot ? 0 : 1;
        return (slot - slotAdjustment) / 2;
    }

    private final int getInfoListIndexBySelectableId(long id) {
        Integer n = this.selectableIdToInfoListIndex.get(id);
        if (n == null) {
            boolean bl = false;
            String string = "Invalid selectableId: " + id;
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)n).intValue();
    }

    public static final /* synthetic */ void access$createAndPutSubSelection(MultiSelectionLayout $this, Map $receiver, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        $this.createAndPutSubSelection($receiver, selection, info, minOffset, maxOffset);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

