/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.DataIterator;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SourceInformationGroupIterator;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\rH\u0016J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010\u00a8\u0006,"}, d2={"Landroidx/compose/runtime/SlotTableGroup;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "table", "Landroidx/compose/runtime/SlotTable;", "group", "", "version", "(Landroidx/compose/runtime/SlotTable;II)V", "compositionGroups", "getCompositionGroups", "()Ljava/lang/Iterable;", "data", "", "getData", "getGroup", "()I", "groupSize", "getGroupSize", "identity", "getIdentity", "()Ljava/lang/Object;", "isEmpty", "", "()Z", "key", "getKey", "node", "getNode", "slotsSize", "getSlotsSize", "sourceInfo", "", "getSourceInfo", "()Ljava/lang/String;", "getTable", "()Landroidx/compose/runtime/SlotTable;", "getVersion", "find", "identityToFind", "iterator", "", "validateRead", "", "runtime"})
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3747:1\n152#2,8:3748\n1#3:3756\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n*L\n3279#1:3748,8\n*E\n"})
final class SlotTableGroup
implements CompositionGroup,
Iterable<CompositionGroup>,
KMappedMarker {
    @NotNull
    private final SlotTable table;
    private final int group;
    private final int version;

    public SlotTableGroup(@NotNull SlotTable table, int group, int version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.group = group;
        this.version = version;
    }

    public /* synthetic */ SlotTableGroup(SlotTable slotTable, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = slotTable.getVersion$runtime();
        }
        this(slotTable, n, n2);
    }

    @NotNull
    public final SlotTable getTable() {
        return this.table;
    }

    public final int getGroup() {
        return this.group;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group) == 0;
    }

    @Override
    @NotNull
    public Object getKey() {
        Object object;
        if (SlotTableKt.access$hasObjectKey(this.table.getGroups(), this.group)) {
            Object object2 = this.table.getSlots()[SlotTableKt.access$objectKeyIndex(this.table.getGroups(), this.group)];
            object = object2;
            Intrinsics.checkNotNull((Object)object2);
        } else {
            object = SlotTableKt.access$key(this.table.getGroups(), this.group);
        }
        return object;
    }

    @Override
    @Nullable
    public String getSourceInfo() {
        String string;
        if (SlotTableKt.access$hasAux(this.table.getGroups(), this.group)) {
            Object object = this.table.getSlots()[SlotTableKt.access$auxIndex(this.table.getGroups(), this.group)];
            string = object instanceof String ? (String)object : null;
        } else {
            Anchor anchor = this.table.tryAnchor(this.group);
            if (anchor != null) {
                Anchor it = anchor;
                boolean bl = false;
                HashMap<Anchor, GroupSourceInformation> hashMap = this.table.getSourceInformationMap$runtime();
                string = hashMap != null && (hashMap = hashMap.get(it)) != null ? ((GroupSourceInformation)((Object)hashMap)).getSourceInformation() : null;
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    @Nullable
    public Object getNode() {
        return SlotTableKt.access$isNode(this.table.getGroups(), this.group) ? this.table.getSlots()[SlotTableKt.access$nodeIndex(this.table.getGroups(), this.group)] : null;
    }

    @Override
    @NotNull
    public Iterable<Object> getData() {
        return new DataIterator(this.table, this.group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object getIdentity() {
        Anchor anchor;
        this.validateRead();
        SlotTable this_$iv = this.table;
        boolean $i$f$read = false;
        boolean bl = false;
        try (SlotReader reader$iv = this_$iv.openReader();){
            SlotReader it = reader$iv;
            boolean bl2 = false;
            anchor = it.anchor(this.group);
        }
        return anchor;
    }

    @Override
    @NotNull
    public Iterable<CompositionGroup> getCompositionGroups() {
        return this;
    }

    @Override
    @NotNull
    public Iterator<CompositionGroup> iterator() {
        Iterator iterator2;
        this.validateRead();
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation it = groupSourceInformation;
            boolean bl = false;
            iterator2 = new SourceInformationGroupIterator(this.table, it);
        } else {
            iterator2 = new GroupIterator(this.table, this.group + 1, this.group + SlotTableKt.access$groupSize(this.table.getGroups(), this.group));
        }
        return iterator2;
    }

    @Override
    public int getGroupSize() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group);
    }

    @Override
    public int getSlotsSize() {
        int nextGroup = this.group + this.getGroupSize();
        int nextSlot = nextGroup < this.table.getGroupsSize() ? SlotTableKt.access$dataAnchor(this.table.getGroups(), nextGroup) : this.table.getSlotsSize();
        return nextSlot - SlotTableKt.access$dataAnchor(this.table.getGroups(), this.group);
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nullable
    public CompositionGroup find(@NotNull Object identityToFind) {
        SlotTableGroup slotTableGroup;
        Intrinsics.checkNotNullParameter((Object)identityToFind, (String)"identityToFind");
        Anchor anchor = identityToFind instanceof Anchor ? (Anchor)identityToFind : null;
        if (anchor != null) {
            int anchorGroup;
            Anchor anchor2 = anchor;
            boolean bl = false;
            slotTableGroup = this.table.ownsAnchor(anchor2) ? ((anchorGroup = this.table.anchorIndex(anchor2)) >= this.group && anchorGroup - this.group < SlotTableKt.access$groupSize(this.table.getGroups(), this.group) ? new SlotTableGroup(this.table, anchorGroup, this.version) : null) : null;
        } else {
            slotTableGroup = null;
        }
        return slotTableGroup;
    }
}

