package com.candata.login.zoo.oauth2.beans;

import static java.nio.file.StandardOpenOption.TRUNCATE_EXISTING;
import static java.nio.file.StandardOpenOption.WRITE;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;

import org.json.JSONObject;

import com.candata.login.utils.FolderUtils;

public class LastLogin
{

	public static Optional<String> getEmail()
	{
		return get(EMAIL_KEY);
	}

	public static Optional<String> getCompany()
	{
		return get(COMPANY_KEY);
	}

	public static Boolean getRememberMe()
	{
		return get(REMEMBER_ME_KEY)
				.map(Boolean::valueOf)
				.orElse(Boolean.FALSE);
	}

	public static void save(String email, String company, Boolean rememberMe)
	{
		JSONObject data = new JSONObject();
		data.put(EMAIL_KEY, email);
		data.put(COMPANY_KEY, company);
		data.put(REMEMBER_ME_KEY, rememberMe.toString());
		try
		{
			if (!getUserFile().exists())
			{
				getUserFile().createNewFile();
			}
			Files.writeString(getUserFile().toPath(), data.toString(), TRUNCATE_EXISTING, WRITE);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	private static Optional<String> get(String key)
	{
		if (!getUserFile().exists())
		{
			return Optional.empty();
		}
		try
		{
			if (data == null)
			{
				data = new JSONObject(Files.readString(getUserFile().toPath()));
			}
			return Optional.ofNullable(data.optString(key));
		}
		catch (Exception e)
		{
			return Optional.empty();
		}
	}

	private static File getUserFile()
	{
		if (LAST_LOGIN_FILE == null)
		{
			LAST_LOGIN_FILE = new File(FolderUtils.getCandataDirectory(), LAST_LOGIN_FILENAME);
		}
		return LAST_LOGIN_FILE;
	}

	private static File LAST_LOGIN_FILE;
	private static final String LAST_LOGIN_FILENAME = "lastlogin";
	private static final String EMAIL_KEY = "email";
	private static final String COMPANY_KEY = "company";
	private static final String REMEMBER_ME_KEY = "rememberMe";
	private static JSONObject data;
}
