package com.candata.login.zoo.os;

import java.util.stream.Stream;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import com.candata.login.utils.Platform;

public class SWT
{
	protected static float DEFAULT_DPI = 96.0f;

	public static Stream<String> getPackagesToExport()
	{
		String osPackages = switch (Platform.getOS())
		{
		case OSX -> OSXPackages;
		case Windows -> WindowsPackages;
		case GTK -> throw new UnsupportedOperationException("Unimplemented case: " + Platform.getOS());
		};
		return Stream.of((BasePackages + "," + osPackages).split(","));
	}

	static final String BasePackages = """
			org.eclipse.swt,
			org.eclipse.swt.accessibility,
			org.eclipse.swt.awt,
			org.eclipse.swt.browser,
			org.eclipse.swt.custom,
			org.eclipse.swt.dnd,
			org.eclipse.swt.events,
			org.eclipse.swt.graphics,
			org.eclipse.swt.internal.image,
			org.eclipse.swt.internal,
			org.eclipse.swt.layout,
			org.eclipse.swt.opengl,
			org.eclipse.swt.printing,
			org.eclipse.swt.program,
			org.eclipse.swt.widgets
			""";
	static final String OSXPackages = """
			org.eclipse.swt.internal.cocoa,
			org.eclipse.swt.internal.graphics
			""";
	static final String WindowsPackages = """
			org.eclipse.swt.internal.gdip,
			org.eclipse.swt.internal.ole.win32,
			org.eclipse.swt.internal.opengl.win32,
			org.eclipse.swt.internal.win32,
			org.eclipse.swt.ole.win32
			""";

	public static Composite adjustDPI(Composite composite)
	{
		if (getMagnification() == 1.0f)
		{
			return composite;
		}
		adjust(composite);
		return composite;
	}

	protected static float getMagnification()
	{
		if (Platform.isOSX())
		{
			return 1f;
		}
		float currentDPI = Display.getDefault().getDPI().x;
		return currentDPI / DEFAULT_DPI;
	}

	protected static void adjust(Composite composite)
	{
		for (Control child : composite.getChildren())
		{
			adjustLayout(child);
			if (child instanceof Composite)
			{
				adjust((Composite) child);
			}
		}
	}

	protected static void adjustLayout(Control control)
	{
		Object layoutData = control.getLayoutData();
		if (layoutData instanceof GridData)
		{
			GridData gd_control = (GridData) layoutData;
			if (gd_control.heightHint != -1)
			{
				gd_control.heightHint = new Float(gd_control.heightHint * getMagnification()).intValue();
			}
			if (gd_control.widthHint != -1)
			{
				gd_control.widthHint = new Float(gd_control.widthHint * getMagnification()).intValue();
			}
			if (gd_control.minimumHeight != 0)
			{
				gd_control.minimumHeight = new Float(gd_control.heightHint * getMagnification()).intValue();
			}
			if (gd_control.minimumWidth != 0)
			{
				gd_control.minimumWidth = new Float(gd_control.heightHint * getMagnification()).intValue();
			}
			control.setLayoutData(gd_control);
		}
	}
}
