package com.candata.login.zoo.osgi;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.logging.Level;

import com.candata.login.oauth.users.Company;
import com.candata.login.utils.FolderUtils;

public class WorkingFolder implements java.io.Closeable
{
	public WorkingFolder(Company company)
	{
		this.company = company;
	}

	public File getDirectory()
	{
		if (workingDir == null)
		{
			File cacheDirectory = FolderUtils.getCandataDirectory();
			workingDir = findWorkingDir(cacheDirectory);
			System.setProperty("candata.workingDir", workingDir.getAbsolutePath());
			OSGiStarter.error("working folder: " + workingDir.getAbsolutePath());
		}
		return workingDir;
	}

	@Override
	public void close()
	{
		unlock();
	}

	protected void unlock()
	{
		try
		{
			if (lockFileLock != null)
			{
				lockFileLock.release();
				lockFileLock.close();
			}
			if (lockFileAccess != null)
			{
				lockFileAccess.close();
			}
		}
		catch (IOException e)
		{
		}
		finally
		{
			if (lockFile != null)
			{
				lockFile.delete();
			}
		}
	}

	protected File findWorkingDir(File baseDir)
	{
		String workingDir = company.getRealm();
		Integer increment = 1;
		while (folderIsLocked(baseDir, workingDir) && increment < 10)
		{
			workingDir = workingDir + increment++;
		}
		return (increment == 10) ? null : new File(baseDir, workingDir);
	}

	protected boolean folderIsLocked(File baseDir, String schema)
	{
		try
		{
			File baseFolder = new File(baseDir, schema);
			if (!baseFolder.exists())
			{
				baseFolder.mkdirs();
			}
			lockFile = new File(baseFolder, "lock.pid");
			lockFileAccess = new RandomAccessFile(lockFile, "rw");
			lockFileLock = lockFileAccess.getChannel().tryLock();
			if (lockFileLock != null)
			{
				String processName = java.lang.management.ManagementFactory.getRuntimeMXBean().getName();
				lockFileAccess.writeChars(processName.split("@")[0]);
			}
			return lockFileLock == null;
		}
		catch (IOException e)
		{
			System.err.println("can't find folder");
			logger.log(Level.SEVERE, "can't find folder", e);
		}
		return false;
	}

	public File getRepository()
	{
		return new File(System.getProperty(FolderUtils.CANDATA_DIR_PROPERTY), "repository");
	}

	Company company;
	File workingDir;
	protected FileLock lockFileLock;
	protected File lockFile;
	protected RandomAccessFile lockFileAccess;
	protected static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("Candata");
}
