package com.candata.login.zoo.provision.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Consumer;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import com.candata.login.zoo.provision.interfaces.Progress;
import com.candata.login.zoo.provision.interfaces.ProgressMonitor;

public class ProgressMonitorUpdaterImpl
{
	public static ServiceRegistration<Consumer> register(BundleContext ctx, ProgressMonitor monitor)
	{
		return new ProgressMonitorUpdaterImpl().doRegister(ctx, monitor);
	}

	protected ServiceRegistration<Consumer> doRegister(BundleContext ctx, ProgressMonitor monitor)
	{
		this.monitor = monitor;
		Dictionary<String, String> properties = new Hashtable<>();
		properties.put("name", "ProgressMonitorUpdater");
		return ctx.registerService(Consumer.class, this::refresh, properties);
	}

	protected void refresh(Object value)
	{
		if (value == null || !(value instanceof String))
		{
			monitor.complete();
			return;
		}
		monitor.update(Progress.indeterminate((String) value));
	}

	ProgressMonitor monitor;
}
