package com.candata.login.zoo.provision.interfaces;

public record Progress(Integer value, String description, String progress)
{
	public boolean isIndeterminate()
	{
		return value() != null && value() == -1;
	}

	public boolean hasValue()
	{
		return value() != null;
	}

	public boolean hasDescription()
	{
		return description() != null;
	}

	public boolean hasProgress()
	{
		return progress() != null;
	}

	public static Progress progress(String progress)
	{
		return new Progress(null, null, progress);
	}

	public static Progress create(Integer total, String description)
	{
		return new Progress(total, description, null);
	}

	public static Progress update(Integer value)
	{
		return new Progress(value, null, null);
	}

	public static Progress update(String progress)
	{
		return new Progress(null, null, progress);
	}

	public static Progress indeterminate(String description)
	{
		return new Progress(-1, description, null);
	}

}
