package com.candata.login.zoo.users;

import static com.candata.login.utils.StringUtils.EMPTY;
import static com.candata.login.zoo.users.UserParser.APPLICATION_KEY;
import static com.candata.login.zoo.users.UserParser.CLIENT_SECRET_KEY;
import static com.candata.login.zoo.users.UserParser.COMPANIES_KEY;
import static com.candata.login.zoo.users.UserParser.COMPANY_NAME_KEY;
import static com.candata.login.zoo.users.UserParser.NAMESPACE_KEY;

import org.json.JSONArray;
import org.json.JSONObject;

import com.candata.login.oauth.beans.Environment;
import com.candata.login.oauth.oauth2.Constants;
import com.candata.login.oauth.users.Application;
import com.candata.login.oauth.users.Company;

import io.reactivex.rxjava3.core.Observable;

public class Companies
{
	public static Observable<Company> get(JSONArray allUsers)
	{
		/*
		[
		{"email": "jamiedougal@gmail.com", "company": "mckay", "secret": "CR106dUjVFyUOFuVsKeoi52ccxgiuRMa",  "application": "cbsa", "namespace": "playground"},
		{"email": "jamie.dougal@candataglobal.com", "company": "candatatest-test", "secret": "OgtdB3VSsZt09e9UoKDZNPOa6Yaf20mY",  "application": "cbsa", "namespace": "test"},
		{"email": "jamiedougal@gmail.com", "company": "candatatest-test", "secret": "OgtdB3VSsZt09e9UoKDZNPOa6Yaf20mY",  "application": "cbsa", "namespace": "test"},
		{"email": "testuser@jamiedougal.com", "company": "candatatest-test", "secret": "OgtdB3VSsZt09e9UoKDZNPOa6Yaf20mY",  "application": "cbsa", "namespace": "test"}
		]
		 */
		return Observable.fromIterable(allUsers)
				.cast(JSONObject.class)
				.distinct(c -> c.optString(COMPANY_NAME_KEY))
				.map(Companies::create);
	}

	protected static Company create(JSONObject c)
	{
		Company company = new Company();
		company.setName(c.optString(COMPANY_NAME_KEY).replace(Constants.TEST_REALM, EMPTY));
		company.setNamespace(c.optString(NAMESPACE_KEY));
		company.setApplication(Application.get(c.optString(APPLICATION_KEY)));
		company.setClientSecret(c.optString(CLIENT_SECRET_KEY));
		company.setEnvironment(c.optString(COMPANY_NAME_KEY).endsWith(Constants.TEST_REALM) ? Environment.Test : Environment.Production);
		return company;
	}

	protected static JSONObject merge(JSONObject data, JSONArray companies)
	{
		if (!data.has(COMPANIES_KEY))
		{
			data.put(COMPANIES_KEY, companies);
			return data;
		}
		JSONArray current = data.getJSONArray(COMPANIES_KEY);
		companies.forEach(current::put);
		return data;
	}

	protected static Observable<Company> build(JSONObject data)
	{
		return Observable.fromIterable(data.getJSONArray(COMPANIES_KEY))
				.cast(JSONObject.class)
				.map(CompanyParser::parse);
	}
}
