package com.candata.login.zoo.users;

import org.json.JSONObject;

import com.candata.login.oauth.beans.Environment;
import com.candata.login.oauth.users.Company;
import com.candata.login.oauth.users.User;

public class CompanyParser
{
	public static Company parse(JSONObject data)
	{
		Company company = new Company();
		//		 {
		//		        "email": "jamiedougal@gmail.com",
		//		        "company": "mckay",
		//		        "secret": "CR106dUjVFyUOFuVsKeoi52ccxgiuRMa",
		//		        "namespace": "playground"
		//		    }
		company.setName(data.getString(UserParser.COMPANY_NAME_KEY));
		company.setNamespace(data.getString(UserParser.NAMESPACE_KEY));
		//remove after testing
		if (!company.getNamespace().equals("test") && !company.getNamespace().equals("playground") && !company.getNamespace().equals("ustest"))
		{
			company.setEnvironment(Environment.Production);
		}
		else
		{
			company.setEnvironment(Environment.get(data.getString(UserParser.NAMESPACE_KEY)));
		}
		User user = new User(data.getString(UserParser.EMAIL_KEY));
		user.setFirstName(data.optString(UserParser.FIRSTNAME_KEY, ""));
		user.setLastName(data.optString(UserParser.LASTNAME_KEY, ""));
		company.setUser(user);
		return company;
	}
}
