package com.candata.login.zoo.users;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Random;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Key
{
	public Key()
	{
		randomKey = createRandomKey();
		sharedKey = g.modPow(randomKey, p);
	}

	public BigInteger getRandomKey()
	{
		return randomKey;
	}

	public BigInteger getSharedKey()
	{
		return sharedKey;
	}

	private static BigInteger createRandomKey()
	{
		Random random = new Random();
		return new BigInteger(256, random);
	}

	public static String decrypt(byte[] encryptedData, Key key) throws Exception
	{
		ByteArrayInputStream data = new ByteArrayInputStream(encryptedData);

		ByteBuffer buffer = ByteBuffer.allocate(Integer.BYTES);
		buffer.put(data.readNBytes(Integer.BYTES));
		int keyLength = buffer.rewind().getInt();

		BigInteger serverSharedKey = new BigInteger(data.readNBytes(keyLength));
		BigInteger clientSecretKey = serverSharedKey.modPow(key.getRandomKey(), p);

		return decrypt(data.readAllBytes(), clientSecretKey);
	}

	private static String decrypt(byte[] encryptedData, BigInteger secretKey) throws Exception
	{
		SecretKeySpec secretKeySpec = createSecretKeySpec(secretKey);
		Cipher cipher = Cipher.getInstance(AES_CIPHER);
		cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
		byte[] decryptedBytes = cipher.doFinal(encryptedData);
		return new String(decryptedBytes, StandardCharsets.UTF_8);
	}

	private static SecretKeySpec createSecretKeySpec(BigInteger secretKey)
	{
		byte[] keyBytes = secretKey.toByteArray();
		byte[] validKeyBytes = new byte[16];
		System.arraycopy(keyBytes, 0, validKeyBytes, 0, Math.min(keyBytes.length, validKeyBytes.length));
		return new SecretKeySpec(validKeyBytes, AES);
	}

	BigInteger randomKey;
	BigInteger sharedKey;

	static final BigInteger g = new BigInteger("114895461767757594453232097323436788464");
	static final BigInteger p = new BigInteger("209866905464141457319893291288720972239");

	static final String AES_CIPHER = "AES/ECB/PKCS5Padding";
	static final String AES = "AES";
}
