package com.candata.login.zoo.users;

import static com.candata.login.zoo.users.UserParser.EMAIL_KEY;

import org.json.JSONArray;
import org.json.JSONObject;

import com.candata.login.oauth.users.User;

import io.reactivex.rxjava3.core.Observable;

public class Users
{
	public static Observable<User> get(JSONArray allUsers)
	{
		return Observable.fromIterable(allUsers)
				.cast(JSONObject.class)
				.distinct(u -> u.optString(EMAIL_KEY))
				.map(UserParser::parse);
	}
}
