package com.candata.login.zoo.utils;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

import com.candata.login.utils.Platform;

public class WindowsUtils
{
	public static final String IGNORE_DARKMODE_SKIN = "darkmode.ignoreSkin";
	private static final String WINDOWS_MANUAL_DARKMODE = "windows.manual.darkmode";

	private static final Color DARK_GRAY = new Color(32, 32, 32);
	private static final Color LIGHT_GRAY = new Color(200, 200, 200);

	public static void configureZoom(Display display)
	{
		if (!Platform.isWindows())
		{
		}
		//		display.setRescalingAtRuntime(true);
		//		System.out.println(display.isRescalingAtRuntime());
	}

	public static void hookDarkModeListeners(Display display)
	{
		if (!Platform.isWindows() || !Display.isSystemDarkTheme())
		{
			return;
		}
		System.setProperty(WINDOWS_MANUAL_DARKMODE, "true");
		setTheme();
		AtomicReference<Listener> skinListener = new AtomicReference<>();
		skinListener.set(skinListener(firstShell -> firstShell
				.addDisposeListener(event -> display.removeListener(SWT.Skin, skinListener.get()))));
		display.addListener(SWT.Skin, skinListener.get());
	}

	protected static void setTheme()
	{
		try
		{
			Class<?> os = Class.forName("org.eclipse.swt.internal.win32.OS");
			Method setTheme = os.getDeclaredMethod("setTheme", Boolean.class);
			setTheme.invoke(null, true);
		}
		catch (Exception e)
		{
		}
	}

	public static void ignoreDarkModeSkin(Control control)
	{
		control.setData(IGNORE_DARKMODE_SKIN, true);
	}

	protected static Listener skinListener(Consumer<Shell> firstShellConsumer)
	{
		AtomicReference<Shell> firstShell = new AtomicReference<>();
		return event -> {
			if (event.widget instanceof Control control)
			{
				if (firstShell.get() == null)
				{
					firstShell.set(control.getShell());
					firstShellConsumer.accept(control.getShell());
				}
				if (control.getData(IGNORE_DARKMODE_SKIN) != null || control.getShell() != firstShell.get())
				{
					return;
				}
				control.setBackground(DARK_GRAY);
				control.setForeground(LIGHT_GRAY);
			}

		};
	}
}