package com.candata.login.utils.zoo.os;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

/**
 * @author Oleg Ryaboy, based on work by Miguel Enriquez
 */
public class WindowsRegistry
{
	/**
	 *
	 * @param location
	 *            path in the registry
	 * @param key
	 *            registry key
	 * @return registry value or null if not found
	 */
	public static final String readRegistry(String location, String key)
	{
		try
		{
			// Run reg query, then read output with StreamReader (internal
			// class)
			Process process = Runtime.getRuntime().exec("reg query " + '"' + location + "\" /v \"" + key + "\"");

			InputStream is = process.getInputStream();
			StringWriter sw = new StringWriter();
			int c;
			while ((c = is.read()) != -1)
			{
				sw.write(c);
			}
			is.close();
			sw.close();
			String output = sw.toString();
			// Output has the following format:
			// \n<Version information>\n\n<key>\t<registry type>\t<value>
			if (!output.contains("REG_SZ"))
			{
				return null;
			}

			// Parse out the value
			String[] parsed = output.split("REG_SZ");
			return parsed[parsed.length - 1].replace("\r\n", "").trim();
		}
		catch (Exception e)
		{
			return null;
		}

	}

	static class StreamReader extends Thread
	{
		private final InputStream is;
		private final StringWriter sw = new StringWriter();

		public StreamReader(InputStream is)
		{
			this.is = is;
		}

		@Override
		public void run()
		{
			try
			{
				int c;
				while ((c = is.read()) != -1)
				{
					sw.write(c);
				}
			}
			catch (IOException e)
			{
			}
		}

		public String getResult()
		{
			return sw.toString();
		}
	}
}