package com.candata.login.oauth.oauth2.beans;

import static java.text.MessageFormat.format;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;

import com.candata.login.oauth.beans.FlowProperties;
import com.candata.login.oauth.oauth2.Constants;
import com.candata.login.oauth.users.Company;

public interface OAuthProperties
{
	public static final String DESKTOP_CLIENT_ID = "candata-application-client";
	public static final String OAUTH_AUDIENCE = "https://iam.googleapis.com/projects/1094879361581/locations/global/workloadIdentityPools/authenticated-user-pool/providers/{0}-provider";
	public static final String TEST_OAUTH_AUDIENCE = "https://iam.googleapis.com/projects/578066310216/locations/global/workloadIdentityPools/authenticated-user-pool/providers/{0}-provider";
	public static final String HEALTH_URL = "https://app.devel.candata.com/rx3/cgi-bin/health.sh";
	public static final String TEST_IAM_PROXY_AUDIENCE = "578066310216-jnn6k2tbri7knp7mm6t6n10p34lo7m8j.apps.googleusercontent.com";
	public static final String IAM_PROXY_AUDIENCE = "1094879361581-5b8v8iua876l5dahvo52llcbiv197bob.apps.googleusercontent.com";
	public static final String TEST_SERVICE_ACCOUNT = "authenticated-app-user@candata-test.iam.gserviceaccount.com";
	public static final String SERVICE_ACCOUNT = "authenticated-app-user@candata-prod.iam.gserviceaccount.com";

	public static final String REMEMBER_ME_KEY = "oauth.remember.me";
	public static final String AUTH_SERVER_DEFAULT = "auth.candata.com";
	public static final String AUTH_SERVER_PROPERTY = "auth.server";
	public static final String NAMESPACE_PAYLOAD_KEY = "cg_namespace";

	public static FlowProperties build(String email, Company company, Boolean rememberMe)
	{
		return new FlowProperties(OAuthProperties.getTokenURL(company),
				OAuthProperties.getAuthURL(company, email),
				OAuthProperties.DESKTOP_CLIENT_ID, company.getClientSecret(), getAudience(company), email,
				company, rememberMe);
	}

	public static URL getTokenURL(Company company)
	{
		String TOKEN_URL = "https://{0}/realms/{1}/protocol/openid-connect/token";
		try
		{
			return new URL(MessageFormat.format(TOKEN_URL, getAuthServer(), company.getRealm()));
		}
		catch (MalformedURLException e)
		{
			throw new RuntimeException(e);
		}
	}

	public static String getAuthServer()
	{
		return System.getProperty(AUTH_SERVER_PROPERTY, AUTH_SERVER_DEFAULT);
	}

	public static boolean isTestAuthServer()
	{
		return getAuthServer().contains(Constants.DEVEL_DOMAIN_INSERT);
	}

	public static URL getAuthURL(Company company, String email)
	{
		String AUTH_URL = "https://{0}/realms/{1}/protocol/openid-connect/auth";
		if ((email != null) && !"".equals(email))
		{
			AUTH_URL = AUTH_URL + "?login_hint=" + email;
		}
		try
		{
			return new URL(MessageFormat.format(AUTH_URL, getAuthServer(), company.getRealm()));
		}
		catch (MalformedURLException e)
		{
			throw new RuntimeException(e);
		}
	}

	public static String getServiceAccount(Company company)
	{
		if (company.isTestEnvironment())
		{
			return TEST_SERVICE_ACCOUNT;
		}
		return SERVICE_ACCOUNT;
	}

	public static String getIAMProxyAudience(Company company)
	{
		if (company.isTestEnvironment())
		{
			return TEST_IAM_PROXY_AUDIENCE;
		}
		return IAM_PROXY_AUDIENCE;
	}

	public static String getAudience(Company company)
	{
		String audience = company.isTestEnvironment() ? format(TEST_OAUTH_AUDIENCE, company.getName()) : format(OAUTH_AUDIENCE, company.getName());
		if (isTestAuthServer())
		{
			audience += "-auth-devel";
		}
		return audience;
	}
}
