package com.candata.login.oauth.oauth2.beans;

import com.candata.login.oauth.beans.Authentication;
import com.candata.login.oauth.beans.Authentication.SupportAuthentications;

public class ValidationResponse
{
	public ValidationResponse(SupportAuthentications authentications, int responseCode, String message)
	{
		this((Authentication) null, responseCode, message);
		this.authentications = authentications;
	}

	public ValidationResponse(Authentication authentication, int responseCode, String message)
	{
		this.authentication = authentication;
		this.responseCode = responseCode;
		this.message = message;
	}

	public SupportAuthentications getAuthentications()
	{
		return authentications;
	}

	public Authentication getAuthentication()
	{
		return authentication;
	}

	public int getResponseCode()
	{
		return responseCode;
	}

	public String getMessage()
	{
		return message;
	}

	@Override
	public String toString()
	{
		if (authentications != null)
		{
			return authentications.getTest() + " " + authentications.getProduction() + " (" + responseCode + ") " + message;
		}
		return authentication + " (" + responseCode + ") " + message;
	}

	SupportAuthentications authentications;
	Authentication authentication;
	int responseCode;
	String message;
}