package com.candata.login.oauth.support.oauth2;

import java.net.URI;
import java.net.http.HttpRequest.Builder;

import org.json.JSONArray;

import com.candata.login.oauth.beans.Authentication;
import com.candata.login.oauth.beans.Authentication.SupportAuthentications;
import com.candata.login.oauth.beans.Environment;
import com.candata.login.oauth.oauth2.beans.OAuthProperties;
import com.candata.login.oauth.oauth2.beans.ValidationResponse;
import com.candata.login.oauth.support.oauth2.beans.OAuthSupportProperties;
import com.candata.login.utils.HttpUtils;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;

public class ValidateToken
{
	public static Maybe<ValidationResponse> validate(Authentication auth)
	{
		return getNamespaces(auth)
				.filter(ns -> ns.length() > 0)
				.map(ns -> new ValidationResponse(auth, 200, ns.toString()));
	}

	public static Maybe<ValidationResponse> getNamespaces(SupportAuthentications authentications)
	{
		return getNamespaces(authentications.getTest())
				.concatWith(getNamespaces(authentications.getProduction()))
				.reduce(new JSONArray(), ValidateToken::merge)
				.filter(ns -> ns.length() > 0)
				.map(ns -> new ValidationResponse(authentications, 200, ns.toString()));
	}

	public static Maybe<ValidationResponse> getAllUsers(SupportAuthentications authentications)
	{
		Authentication authentication = OAuthProperties.isTestAuthServer() ? authentications.getTest() : authentications.getProduction();
		return HttpUtils.buildGet(URI.create(OAuthSupportProperties.getAllUsersURL()), authentication.getIdToken())
				.subscribeOn(Schedulers.computation())
				.toMaybe()
				.map(Builder::build)
				.flatMap(HttpUtils::doRequest)
				.map(data -> new ValidationResponse(authentication, 200, data));
	}

	protected static Maybe<JSONArray> getNamespaces(Authentication authentication)
	{
		Environment environment = OAuthProperties.TEST_IAM_PROXY_AUDIENCE.equals(authentication.getIdTokenPayload().getString("aud"))
				? Environment.Test
				: Environment.Production;
		return HttpUtils
				.buildGet(URI.create(OAuthSupportProperties.getNamespacesURL(environment)),
						authentication.getIdToken())
				.subscribeOn(Schedulers.computation())
				.toMaybe()
				.map(Builder::build)
				.flatMap(HttpUtils::doRequest)
				.map(JSONArray::new);
	}

	protected static JSONArray merge(JSONArray mergeTo, JSONArray source)
	{
		for (int i = 0; i < source.length(); i++)
		{
			mergeTo.put(source.getJSONObject(i));
		}
		return mergeTo;
	}
}
