package com.candata.login.oauth.zoo.oauth2;

import static com.candata.login.utils.StringUtils.EMPTY;

import java.io.IOException;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.candata.login.oauth.zoo.oauth2.ui.AuthenticateShell;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp.Browser;

public class AuthenticationBrowser implements Browser
{
	public AuthenticationBrowser(Runnable onCancel, String closeTriggerText)
	{
		this.onCancel = onCancel;
		this.closeTriggerText = closeTriggerText;
	}

	@Override
	public void browse(String url) throws IOException
	{
		//		Program.launch(url);
		Display display = Display.getDefault();
		display.asyncExec(() -> {
			if (!display.isDisposed())
			{
				Shell currentShell = display.getActiveShell();
				((currentShell != null) ? new AuthenticateShell(currentShell) : new AuthenticateShell(display))
						.setCloseTriggerText(closeTriggerText)
						.setOnCancel(onCancel)
						.authenticate(url);
			}
		});
	}

	String closeTriggerText = EMPTY;
	Runnable onCancel;
}
