package com.candata.login.oauth.zoo.support.oauth2.beans;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdTokenResponse;

public class IdCredential
{
	public static IdCredential create(TokenResponse response)
	{
		return new IdCredential().setFromTokenResponse(response);
	}

	public IdCredential()
	{
	}

	private IdCredential setFromTokenResponse(TokenResponse response)
	{
		if (response instanceof IdTokenResponse)
		{
			idToken = ((IdTokenResponse) response).getIdToken();
		}
		accessToken = response.getAccessToken();
		refreshToken = response.getRefreshToken();
		expiresInSeconds = response.getExpiresInSeconds();
		return this;
	}

	public String getIdToken()
	{
		return idToken;
	}

	public void setIdToken(String idToken)
	{
		this.idToken = idToken;
	}

	public String getAccessToken()
	{
		return accessToken;
	}

	public void setAccessToken(String accessToken)
	{
		this.accessToken = accessToken;
	}

	public String getRefreshToken()
	{
		return refreshToken;
	}

	public IdCredential setRefreshToken(String refreshToken)
	{
		this.refreshToken = refreshToken;
		return this;
	}

	public Long getExpiresInSeconds()
	{
		return expiresInSeconds;
	}

	public void setExpiresInSeconds(Long expiresInSeconds)
	{
		this.expiresInSeconds = expiresInSeconds;
	}

	String idToken;
	String accessToken;
	String refreshToken;
	Long expiresInSeconds;
}
